/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.pattern;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.PatternLayout;
import ch.qos.logback.classic.pattern.ExtendedThrowableProxyConverter;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.LoggingEvent;
import ch.qos.logback.core.Context;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import junit.framework.Assert;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class ExtendedThrowableProxyConverterTest {
    LoggerContext lc = new LoggerContext();
    ExtendedThrowableProxyConverter etpc = new ExtendedThrowableProxyConverter();
    StringWriter sw = new StringWriter();
    PrintWriter pw = new PrintWriter(this.sw);

    @Before
    public void setUp() throws Exception {
        this.etpc.setContext((Context)this.lc);
        this.etpc.start();
    }

    @After
    public void tearDown() throws Exception {
    }

    private ILoggingEvent createLoggingEvent(Throwable t) {
        return new LoggingEvent(this.getClass().getName(), this.lc.getLogger("ROOT"), Level.DEBUG, "test message", t, null);
    }

    @Test
    public void integration() {
        PatternLayout pl = new PatternLayout();
        pl.setContext((Context)this.lc);
        pl.setPattern("%m%n");
        pl.start();
        ILoggingEvent e = this.createLoggingEvent(new Exception("x"));
        String res = pl.doLayout(e);
        Pattern p = Pattern.compile("\\s*at .*?\\[.*?\\]");
        Matcher m = p.matcher(res);
        int i = 0;
        while (m.find()) {
            ++i;
        }
        Assert.assertTrue((String)(i + " should be larger than 1"), (i >= 1 ? 1 : 0) != 0);
    }

    @Test
    public void smoke() {
        Exception t = new Exception("smoke");
        this.verify(t);
    }

    @Test
    public void nested() {
        Throwable t = this.makeNestedException(1);
        this.verify(t);
    }

    void verify(Throwable t) {
        t.printStackTrace(this.pw);
        ILoggingEvent le = this.createLoggingEvent(t);
        String result = this.etpc.convert(le);
        result = result.replace("common frames omitted", "more");
        result = result.replaceAll(" ~?\\[.*\\]", "");
        Assert.assertEquals((String)this.sw.toString(), (String)result);
    }

    Throwable makeNestedException(int level) {
        if (level == 0) {
            return new Exception("nesting level=" + level);
        }
        Throwable cause = this.makeNestedException(level - 1);
        return new Exception("nesting level =" + level, cause);
    }
}

