/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.pattern;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.pattern.MarkerConverter;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.LoggingEvent;
import junit.framework.Assert;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.IMarkerFactory;
import org.slf4j.Marker;
import org.slf4j.helpers.BasicMarkerFactory;

public class MarkerConverterTest {
    LoggerContext lc;
    MarkerConverter converter;
    IMarkerFactory markerFactory = new BasicMarkerFactory();

    @Before
    public void setUp() throws Exception {
        this.lc = new LoggerContext();
        this.converter = new MarkerConverter();
        this.converter.start();
    }

    @After
    public void tearDown() throws Exception {
        this.lc = null;
        this.converter.stop();
        this.converter = null;
    }

    @Test
    public void testWithNullMarker() {
        String result = this.converter.convert(this.createLoggingEvent(null));
        Assert.assertEquals((String)"", (String)result);
    }

    @Test
    public void testWithMarker() {
        String name = "test";
        Marker marker = this.markerFactory.getMarker(name);
        String result = this.converter.convert(this.createLoggingEvent(marker));
        Assert.assertEquals((String)name, (String)result);
    }

    @Test
    public void testWithOneChildMarker() {
        Marker marker = this.markerFactory.getMarker("test");
        marker.add(this.markerFactory.getMarker("child"));
        String result = this.converter.convert(this.createLoggingEvent(marker));
        Assert.assertEquals((String)"test [ child ]", (String)result);
    }

    @Test
    public void testWithSeveralChildMarker() {
        Marker marker = this.markerFactory.getMarker("testParent");
        marker.add(this.markerFactory.getMarker("child1"));
        marker.add(this.markerFactory.getMarker("child2"));
        marker.add(this.markerFactory.getMarker("child3"));
        String result = this.converter.convert(this.createLoggingEvent(marker));
        Assert.assertEquals((String)"testParent [ child1, child2, child3 ]", (String)result);
    }

    private ILoggingEvent createLoggingEvent(Marker marker) {
        LoggingEvent le = new LoggingEvent(this.getClass().getName(), this.lc.getLogger("ROOT"), Level.DEBUG, "test message", null, null);
        le.setMarker(marker);
        return le;
    }
}

