/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.pattern;

import ch.qos.logback.classic.pattern.TargetLengthBasedClassNameAbbreviator;
import junit.framework.Assert;
import org.junit.Test;

public class TargetLengthBasedClassNameAbbreviatorTest {
    @Test
    public void testShortName() {
        TargetLengthBasedClassNameAbbreviator abbreviator = new TargetLengthBasedClassNameAbbreviator(100);
        String name = "hello";
        Assert.assertEquals((String)name, (String)abbreviator.abbreviate(name));
        abbreviator = new TargetLengthBasedClassNameAbbreviator(100);
        name = "hello.world";
        Assert.assertEquals((String)name, (String)abbreviator.abbreviate(name));
    }

    @Test
    public void testNoDot() {
        TargetLengthBasedClassNameAbbreviator abbreviator = new TargetLengthBasedClassNameAbbreviator(1);
        String name = "hello";
        Assert.assertEquals((String)name, (String)abbreviator.abbreviate(name));
    }

    @Test
    public void testOneDot() {
        TargetLengthBasedClassNameAbbreviator abbreviator = new TargetLengthBasedClassNameAbbreviator(1);
        String name = "hello.world";
        Assert.assertEquals((String)"h.world", (String)abbreviator.abbreviate(name));
        abbreviator = new TargetLengthBasedClassNameAbbreviator(1);
        name = "h.world";
        Assert.assertEquals((String)"h.world", (String)abbreviator.abbreviate(name));
        abbreviator = new TargetLengthBasedClassNameAbbreviator(1);
        name = ".world";
        Assert.assertEquals((String)".world", (String)abbreviator.abbreviate(name));
    }

    @Test
    public void testTwoDot() {
        TargetLengthBasedClassNameAbbreviator abbreviator = new TargetLengthBasedClassNameAbbreviator(1);
        String name = "com.logback.Foobar";
        Assert.assertEquals((String)"c.l.Foobar", (String)abbreviator.abbreviate(name));
        abbreviator = new TargetLengthBasedClassNameAbbreviator(1);
        name = "c.logback.Foobar";
        Assert.assertEquals((String)"c.l.Foobar", (String)abbreviator.abbreviate(name));
        abbreviator = new TargetLengthBasedClassNameAbbreviator(1);
        name = "c..Foobar";
        Assert.assertEquals((String)"c..Foobar", (String)abbreviator.abbreviate(name));
        abbreviator = new TargetLengthBasedClassNameAbbreviator(1);
        name = "..Foobar";
        Assert.assertEquals((String)"..Foobar", (String)abbreviator.abbreviate(name));
    }

    @Test
    public void test3Dot() {
        TargetLengthBasedClassNameAbbreviator abbreviator = new TargetLengthBasedClassNameAbbreviator(1);
        String name = "com.logback.xyz.Foobar";
        Assert.assertEquals((String)"c.l.x.Foobar", (String)abbreviator.abbreviate(name));
        abbreviator = new TargetLengthBasedClassNameAbbreviator(13);
        name = "com.logback.xyz.Foobar";
        Assert.assertEquals((String)"c.l.x.Foobar", (String)abbreviator.abbreviate(name));
        abbreviator = new TargetLengthBasedClassNameAbbreviator(14);
        name = "com.logback.xyz.Foobar";
        Assert.assertEquals((String)"c.l.xyz.Foobar", (String)abbreviator.abbreviate(name));
        abbreviator = new TargetLengthBasedClassNameAbbreviator(15);
        name = "com.logback.alligator.Foobar";
        Assert.assertEquals((String)"c.l.a.Foobar", (String)abbreviator.abbreviate(name));
    }

    @Test
    public void testXDot() {
        TargetLengthBasedClassNameAbbreviator abbreviator = new TargetLengthBasedClassNameAbbreviator(21);
        String name = "com.logback.wombat.alligator.Foobar";
        Assert.assertEquals((String)"c.l.w.a.Foobar", (String)abbreviator.abbreviate(name));
        abbreviator = new TargetLengthBasedClassNameAbbreviator(22);
        name = "com.logback.wombat.alligator.Foobar";
        Assert.assertEquals((String)"c.l.w.alligator.Foobar", (String)abbreviator.abbreviate(name));
        abbreviator = new TargetLengthBasedClassNameAbbreviator(1);
        name = "com.logback.wombat.alligator.tomato.Foobar";
        Assert.assertEquals((String)"c.l.w.a.t.Foobar", (String)abbreviator.abbreviate(name));
        abbreviator = new TargetLengthBasedClassNameAbbreviator(21);
        name = "com.logback.wombat.alligator.tomato.Foobar";
        Assert.assertEquals((String)"c.l.w.a.tomato.Foobar", (String)abbreviator.abbreviate(name));
        abbreviator = new TargetLengthBasedClassNameAbbreviator(29);
        name = "com.logback.wombat.alligator.tomato.Foobar";
        Assert.assertEquals((String)"c.l.w.alligator.tomato.Foobar", (String)abbreviator.abbreviate(name));
    }
}

