/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.pattern;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.pattern.ThrowableProxyConverter;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.LoggingEvent;
import ch.qos.logback.classic.util.TeztHelper;
import ch.qos.logback.core.Context;
import java.io.BufferedReader;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.List;
import org.junit.After;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;

public class ThrowableProxyConverterTest {
    LoggerContext lc = new LoggerContext();
    ThrowableProxyConverter tpc = new ThrowableProxyConverter();
    StringWriter sw = new StringWriter();
    PrintWriter pw = new PrintWriter(this.sw);

    @Before
    public void setUp() throws Exception {
        this.tpc.setContext((Context)this.lc);
        this.tpc.start();
    }

    @After
    public void tearDown() throws Exception {
    }

    private ILoggingEvent createLoggingEvent(Throwable t) {
        return new LoggingEvent(this.getClass().getName(), this.lc.getLogger("ROOT"), Level.DEBUG, "test message", t, null);
    }

    @Test
    public void suppressed() throws InvocationTargetException, IllegalAccessException {
        Assume.assumeTrue((boolean)TeztHelper.suppressedSupported());
        Exception ex = null;
        try {
            this.someMethod();
        }
        catch (Exception e) {
            Exception fooException = new Exception("Foo");
            Exception barException = new Exception("Bar");
            TeztHelper.addSuppressed(e, fooException);
            TeztHelper.addSuppressed(e, barException);
            ex = e;
        }
        this.verify(ex);
    }

    @Test
    public void suppressedWithCause() throws InvocationTargetException, IllegalAccessException {
        Assume.assumeTrue((boolean)TeztHelper.suppressedSupported());
        Exception ex = null;
        try {
            this.someMethod();
        }
        catch (Exception e) {
            ex = new Exception("Wrapper", e);
            Exception fooException = new Exception("Foo");
            Exception barException = new Exception("Bar");
            TeztHelper.addSuppressed(ex, fooException);
            TeztHelper.addSuppressed(e, barException);
        }
        this.verify(ex);
    }

    @Test
    public void suppressedWithSuppressed() throws Exception {
        Assume.assumeTrue((boolean)TeztHelper.suppressedSupported());
        Exception ex = null;
        try {
            this.someMethod();
        }
        catch (Exception e) {
            ex = new Exception("Wrapper", e);
            Exception fooException = new Exception("Foo");
            Exception barException = new Exception("Bar");
            TeztHelper.addSuppressed(barException, fooException);
            TeztHelper.addSuppressed(e, barException);
        }
        this.verify(ex);
    }

    @Test
    public void smoke() {
        Exception t = new Exception("smoke");
        this.verify(t);
    }

    @Test
    public void nested() {
        Throwable t = TeztHelper.makeNestedException(1);
        this.verify(t);
    }

    @Test
    public void withArgumentOfOne() throws Exception {
        Throwable t = TeztHelper.makeNestedException(0);
        t.printStackTrace(this.pw);
        ILoggingEvent le = this.createLoggingEvent(t);
        List<String> optionList = Arrays.asList("1");
        this.tpc.setOptionList(optionList);
        this.tpc.start();
        String result = this.tpc.convert(le);
        BufferedReader reader = new BufferedReader(new StringReader(result));
        Assert.assertTrue((boolean)reader.readLine().contains(t.getMessage()));
        Assert.assertNotNull((Object)reader.readLine());
        Assert.assertNull((String)"Unexpected line in stack trace", (Object)reader.readLine());
    }

    @Test
    public void withShortArgument() throws Exception {
        Throwable t = TeztHelper.makeNestedException(0);
        t.printStackTrace(this.pw);
        ILoggingEvent le = this.createLoggingEvent(t);
        List<String> options = Arrays.asList("short");
        this.tpc.setOptionList(options);
        this.tpc.start();
        String result = this.tpc.convert(le);
        BufferedReader reader = new BufferedReader(new StringReader(result));
        Assert.assertTrue((boolean)reader.readLine().contains(t.getMessage()));
        Assert.assertNotNull((Object)reader.readLine());
        Assert.assertNull((String)"Unexpected line in stack trace", (Object)reader.readLine());
    }

    void someMethod() throws Exception {
        throw new Exception("someMethod");
    }

    void verify(Throwable t) {
        t.printStackTrace(this.pw);
        ILoggingEvent le = this.createLoggingEvent(t);
        String result = this.tpc.convert(le);
        System.out.println(result);
        result = result.replace("common frames omitted", "more");
        junit.framework.Assert.assertEquals((String)this.sw.toString(), (String)result);
    }
}

