/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.spi;

import ch.qos.logback.classic.spi.IThrowableProxy;
import ch.qos.logback.classic.spi.ThrowableProxy;
import ch.qos.logback.classic.spi.ThrowableProxyUtil;
import ch.qos.logback.classic.util.TeztHelper;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import junit.framework.Assert;
import org.junit.After;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;

public class ThrowableProxyTest {
    StringWriter sw = new StringWriter();
    PrintWriter pw = new PrintWriter(this.sw);

    @Before
    public void setUp() throws Exception {
    }

    @After
    public void tearDown() throws Exception {
    }

    public void verify(Throwable t) {
        t.printStackTrace(this.pw);
        ThrowableProxy tp = new ThrowableProxy(t);
        String result = ThrowableProxyUtil.asString((IThrowableProxy)tp);
        result = result.replace("common frames omitted", "more");
        String expected = this.sw.toString();
        System.out.println("========expected");
        System.out.println(expected);
        System.out.println("========result");
        System.out.println(result);
        Assert.assertEquals((String)expected, (String)result);
    }

    @Test
    public void smoke() {
        Exception e = new Exception("smoke");
        this.verify(e);
    }

    @Test
    public void nested() {
        Exception w = null;
        try {
            this.someMethod();
        }
        catch (Exception e) {
            w = new Exception("wrapping", e);
        }
        this.verify(w);
    }

    @Test
    public void suppressed() throws InvocationTargetException, IllegalAccessException {
        Assume.assumeTrue((boolean)TeztHelper.suppressedSupported());
        Exception ex = null;
        try {
            this.someMethod();
        }
        catch (Exception e) {
            Exception fooException = new Exception("Foo");
            Exception barException = new Exception("Bar");
            TeztHelper.addSuppressed(e, fooException);
            TeztHelper.addSuppressed(e, barException);
            ex = e;
        }
        this.verify(ex);
    }

    @Test
    public void suppressedWithCause() throws InvocationTargetException, IllegalAccessException {
        Assume.assumeTrue((boolean)TeztHelper.suppressedSupported());
        Exception ex = null;
        try {
            this.someMethod();
        }
        catch (Exception e) {
            ex = new Exception("Wrapper", e);
            Exception fooException = new Exception("Foo");
            Exception barException = new Exception("Bar");
            TeztHelper.addSuppressed(ex, fooException);
            TeztHelper.addSuppressed(e, barException);
        }
        this.verify(ex);
    }

    @Test
    public void suppressedWithSuppressed() throws Exception {
        Assume.assumeTrue((boolean)TeztHelper.suppressedSupported());
        Exception ex = null;
        try {
            this.someMethod();
        }
        catch (Exception e) {
            ex = new Exception("Wrapper", e);
            Exception fooException = new Exception("Foo");
            Exception barException = new Exception("Bar");
            TeztHelper.addSuppressed(barException, fooException);
            TeztHelper.addSuppressed(e, barException);
        }
        this.verify(ex);
    }

    @Test
    public void nullSTE() {
        Exception t = new Exception("someMethodWithNullException"){

            public StackTraceElement[] getStackTrace() {
                return null;
            }
        };
        new ThrowableProxy((Throwable)t);
        Exception top = new Exception("top", t);
        new ThrowableProxy((Throwable)top);
    }

    @Test
    public void multiNested() {
        Exception w = null;
        try {
            this.someOtherMethod();
        }
        catch (Exception e) {
            w = new Exception("wrapping", e);
        }
        this.verify(w);
    }

    void someMethod() throws Exception {
        throw new Exception("someMethod");
    }

    void someMethodWithNullException() throws Exception {
        throw new Exception("someMethodWithNullException"){

            public StackTraceElement[] getStackTrace() {
                return null;
            }
        };
    }

    void someOtherMethod() throws Exception {
        try {
            this.someMethod();
        }
        catch (Exception e) {
            throw new Exception("someOtherMethod", e);
        }
    }
}

