/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.turbo;

import ch.qos.logback.classic.turbo.MarkerFilter;
import ch.qos.logback.core.spi.FilterReply;
import junit.framework.Assert;
import org.junit.Test;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

public class MarkerFilterTest {
    static String TOTO = "TOTO";
    static String COMPOSITE = "COMPOSITE";
    Marker totoMarker = MarkerFactory.getMarker((String)TOTO);

    @Test
    public void testNoMarker() {
        MarkerFilter mkt = new MarkerFilter();
        mkt.start();
        Assert.assertFalse((boolean)mkt.isStarted());
        Assert.assertEquals((Object)FilterReply.NEUTRAL, (Object)mkt.decide(this.totoMarker, null, null, null, null, null));
        Assert.assertEquals((Object)FilterReply.NEUTRAL, (Object)mkt.decide(null, null, null, null, null, null));
    }

    @Test
    public void testBasic() {
        MarkerFilter mkt = new MarkerFilter();
        mkt.setMarker(TOTO);
        mkt.setOnMatch("ACCEPT");
        mkt.setOnMismatch("DENY");
        mkt.start();
        Assert.assertTrue((boolean)mkt.isStarted());
        Assert.assertEquals((Object)FilterReply.DENY, (Object)mkt.decide(null, null, null, null, null, null));
        Assert.assertEquals((Object)FilterReply.ACCEPT, (Object)mkt.decide(this.totoMarker, null, null, null, null, null));
    }

    @Test
    public void testComposite() {
        String compositeMarkerName = COMPOSITE;
        Marker compositeMarker = MarkerFactory.getMarker((String)compositeMarkerName);
        compositeMarker.add(this.totoMarker);
        MarkerFilter mkt = new MarkerFilter();
        mkt.setMarker(TOTO);
        mkt.setOnMatch("ACCEPT");
        mkt.setOnMismatch("DENY");
        mkt.start();
        Assert.assertTrue((boolean)mkt.isStarted());
        Assert.assertEquals((Object)FilterReply.DENY, (Object)mkt.decide(null, null, null, null, null, null));
        Assert.assertEquals((Object)FilterReply.ACCEPT, (Object)mkt.decide(this.totoMarker, null, null, null, null, null));
        Assert.assertEquals((Object)FilterReply.ACCEPT, (Object)mkt.decide(compositeMarker, null, null, null, null, null));
    }
}

