/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.turbo.lru;

import ch.qos.logback.classic.turbo.lru.Event;
import ch.qos.logback.classic.turbo.lru.LRUCache;
import ch.qos.logback.classic.turbo.lru.T_LRUCache;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import junit.framework.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Simulator {
    Random random;
    int worldSize;
    int get2PutRatio;
    boolean multiThreaded;

    public Simulator(int worldSize, int get2PutRatio, boolean multiThreaded) {
        this.worldSize = worldSize;
        this.get2PutRatio = get2PutRatio;
        long seed = System.nanoTime();
        this.random = new Random(seed);
        this.multiThreaded = multiThreaded;
    }

    public List<Event> generateScenario(int len) {
        ArrayList<Event> scenario = new ArrayList<Event>();
        for (int i = 0; i < len; ++i) {
            int r = this.random.nextInt(this.get2PutRatio);
            boolean put = false;
            if (r == 0) {
                put = true;
            }
            r = this.random.nextInt(this.worldSize);
            Event<String> e = new Event<String>(put, String.valueOf(r));
            scenario.add(e);
        }
        return scenario;
    }

    public void simulate(List<Event> scenario, LRUCache<String, String> lruCache, T_LRUCache<String> tlruCache) {
        for (Event e : scenario) {
            if (e.put) {
                lruCache.put((String)e.k, (String)e.k);
                tlruCache.put((String)e.k);
                continue;
            }
            String r0 = (String)lruCache.get(e.k);
            String r1 = tlruCache.get((String)e.k);
            if (this.multiThreaded) continue;
            if (r0 != null) {
                Assert.assertEquals((String)r0, (String)((String)e.k));
            }
            Assert.assertEquals((String)r0, (String)r1);
        }
    }
}

