/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.util;

import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.util.ContextInitializer;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.ConsoleAppender;
import ch.qos.logback.core.joran.spi.JoranException;
import ch.qos.logback.core.status.TrivialStatusListener;
import java.util.List;
import junit.framework.Assert;
import org.junit.After;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

public class ContextInitializerTest {
    LoggerContext loggerContext = new LoggerContext();
    Logger root = this.loggerContext.getLogger("ROOT");

    @Before
    public void setUp() throws Exception {
    }

    @After
    public void tearDown() throws Exception {
        System.clearProperty("logback.configurationFile");
        System.clearProperty("logback.statusListenerClass");
    }

    @Test
    @Ignore
    public void reset() throws JoranException {
        new ContextInitializer(this.loggerContext).autoConfig();
        Appender appender = this.root.getAppender("STDOUT");
        Assert.assertNotNull((Object)appender);
        Assert.assertTrue((boolean)(appender instanceof ConsoleAppender));
        this.loggerContext.stop();
        appender = this.root.getAppender("STDOUT");
        Assert.assertNull((Object)appender);
    }

    @Test
    public void autoConfigFromSystemProperties() throws JoranException {
        this.doAutoConfigFromSystemProperties("src/test/input/autoConfig.xml");
        this.doAutoConfigFromSystemProperties("autoConfigAsResource.xml");
        this.doAutoConfigFromSystemProperties("file:src/test/input/autoConfig.xml");
    }

    public void doAutoConfigFromSystemProperties(String val) throws JoranException {
        System.setProperty("logback.configurationFile", val);
        new ContextInitializer(this.loggerContext).autoConfig();
        Appender appender = this.root.getAppender("AUTO_BY_SYSTEM_PROPERTY");
        Assert.assertNotNull((Object)appender);
    }

    @Test
    public void autoStatusListener() throws JoranException {
        System.setProperty("logback.statusListenerClass", TrivialStatusListener.class.getName());
        List statusListenerList = this.loggerContext.getStatusManager().getCopyOfStatusListenerList();
        Assert.assertEquals((int)0, (int)statusListenerList.size());
        this.doAutoConfigFromSystemProperties("src/test/input/autoConfig.xml");
        statusListenerList = this.loggerContext.getStatusManager().getCopyOfStatusListenerList();
        Assert.assertTrue((String)(statusListenerList.size() + " should be 1"), (statusListenerList.size() == 1 ? 1 : 0) != 0);
        TrivialStatusListener tsl = (TrivialStatusListener)statusListenerList.get(0);
        Assert.assertTrue((String)"expecting at least one event in list", (tsl.list.size() > 0 ? 1 : 0) != 0);
    }
}

