/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.util;

import ch.qos.logback.classic.util.LoggerNameUtil;
import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoggerNameUtilTest {
    @Test
    public void smoke0() {
        ArrayList<String> witnessList = new ArrayList<String>();
        witnessList.add("a");
        witnessList.add("b");
        witnessList.add("c");
        List<String> partList = this.computeNameParts("a.b.c");
        Assert.assertEquals(witnessList, partList);
    }

    @Test
    public void smoke1() {
        ArrayList<String> witnessList = new ArrayList<String>();
        witnessList.add("com");
        witnessList.add("foo");
        witnessList.add("Bar");
        List<String> partList = this.computeNameParts("com.foo.Bar");
        Assert.assertEquals(witnessList, partList);
    }

    @Test
    public void emptyStringShouldReturnAListContainingOneEmptyString() {
        ArrayList<String> witnessList = new ArrayList<String>();
        witnessList.add("");
        List<String> partList = this.computeNameParts("");
        Assert.assertEquals(witnessList, partList);
    }

    @Test
    public void dotAtLastPositionShouldReturnAListWithAnEmptyStringAsLastElement() {
        ArrayList<String> witnessList = new ArrayList<String>();
        witnessList.add("com");
        witnessList.add("foo");
        witnessList.add("");
        List<String> partList = this.computeNameParts("com.foo.");
        Assert.assertEquals(witnessList, partList);
    }

    @Test
    public void supportNestedClasses() {
        ArrayList<String> witnessList = new ArrayList<String>();
        witnessList.add("com");
        witnessList.add("foo");
        witnessList.add("Bar");
        witnessList.add("Nested");
        List<String> partList = this.computeNameParts("com.foo.Bar$Nested");
        Assert.assertEquals(witnessList, partList);
    }

    @Test
    public void supportNestedClassesWithNestedDot() {
        ArrayList<String> witnessList = new ArrayList<String>();
        witnessList.add("com");
        witnessList.add("foo");
        witnessList.add("Bar");
        witnessList.add("Nested");
        witnessList.add("dot");
        List<String> partList = this.computeNameParts("com.foo.Bar$Nested.dot");
        Assert.assertEquals(witnessList, partList);
    }

    @Test
    public void supportNestedClassesAtBeginning() {
        ArrayList<String> witnessList = new ArrayList<String>();
        witnessList.add("foo");
        witnessList.add("Nested");
        witnessList.add("bar");
        List<String> partList = this.computeNameParts("foo$Nested.bar");
        Assert.assertEquals(witnessList, partList);
    }

    private List<String> computeNameParts(String loggerName) {
        ArrayList<String> partList = new ArrayList<String>();
        int fromIndex = 0;
        while (true) {
            int index;
            if ((index = LoggerNameUtil.getSeparatorIndexOf((String)loggerName, (int)fromIndex)) == -1) break;
            partList.add(loggerName.substring(fromIndex, index));
            fromIndex = index + 1;
        }
        partList.add(loggerName.substring(fromIndex));
        return partList;
    }
}

