/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.joran.action;

import ch.qos.logback.classic.net.ReceiverBase;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.joran.action.Action;
import ch.qos.logback.core.joran.spi.ActionException;
import ch.qos.logback.core.joran.spi.InterpretationContext;
import ch.qos.logback.core.spi.LifeCycle;
import ch.qos.logback.core.util.OptionHelper;
import org.xml.sax.Attributes;

public class ReceiverAction
extends Action {
    private ReceiverBase receiver;
    private boolean inError;

    public void begin(InterpretationContext interpretationContext, String string, Attributes attributes) throws ActionException {
        String string2 = attributes.getValue("class");
        if (OptionHelper.isEmpty((String)string2)) {
            this.addError("Missing class name for receiver. Near [" + string + "] line " + this.getLineNumber(interpretationContext));
            this.inError = true;
            return;
        }
        try {
            this.addInfo("About to instantiate receiver of type [" + string2 + "]");
            this.receiver = (ReceiverBase)((Object)OptionHelper.instantiateByClassName((String)string2, ReceiverBase.class, (Context)this.context));
            this.receiver.setContext(this.context);
            interpretationContext.pushObject((Object)this.receiver);
        }
        catch (Exception exception) {
            this.inError = true;
            this.addError("Could not create a receiver of type [" + string2 + "].", exception);
            throw new ActionException((Throwable)exception);
        }
    }

    public void end(InterpretationContext interpretationContext, String string) throws ActionException {
        if (this.inError) {
            return;
        }
        interpretationContext.getContext().register((LifeCycle)this.receiver);
        this.receiver.start();
        Object object = interpretationContext.peekObject();
        if (object != this.receiver) {
            this.addWarn("The object at the of the stack is not the remote pushed earlier.");
        } else {
            interpretationContext.popObject();
        }
    }
}

