/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.util;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.spi.ContextAware;
import ch.qos.logback.core.spi.LifeCycle;
import ch.qos.logback.core.status.StatusListener;
import ch.qos.logback.core.util.OptionHelper;

public class StatusListenerConfigHelper {
    static void installIfAsked(LoggerContext loggerContext) {
        String string = OptionHelper.getSystemProperty((String)"logback.statusListenerClass");
        if (!OptionHelper.isEmpty((String)string)) {
            StatusListenerConfigHelper.addStatusListener(loggerContext, string);
        }
    }

    private static void addStatusListener(LoggerContext loggerContext, String string) {
        StatusListener statusListener = StatusListenerConfigHelper.createListenerPerClassName(loggerContext, string);
        StatusListenerConfigHelper.initListener(loggerContext, statusListener);
    }

    private static void initListener(LoggerContext loggerContext, StatusListener statusListener) {
        if (statusListener != null) {
            if (statusListener instanceof ContextAware) {
                ((ContextAware)statusListener).setContext((Context)loggerContext);
            }
            if (statusListener instanceof LifeCycle) {
                ((LifeCycle)statusListener).start();
            }
            loggerContext.getStatusManager().add(statusListener);
        }
    }

    private static StatusListener createListenerPerClassName(LoggerContext loggerContext, String string) {
        try {
            return (StatusListener)OptionHelper.instantiateByClassName((String)string, StatusListener.class, (Context)loggerContext);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }
}

