/*
 * Decompiled with CFR 0.152.
 */
package com.github.tonybaines.gestalt;

public class ObfuscatedString {
    private static final String PREFIX = "{rot13}";
    private final String obfuscated;

    private ObfuscatedString(String string) {
        this.obfuscated = string.startsWith(PREFIX) ? string.substring(PREFIX.length()) : this.obfuscated(string);
    }

    public static ObfuscatedString fromString(String string) {
        return new ObfuscatedString(string);
    }

    public String toString() {
        return PREFIX + this.obfuscated;
    }

    public String toPlainTextString() {
        return this.deobfuscate(this.obfuscated);
    }

    private String deobfuscate(String obfuscated) {
        return this.rot13(obfuscated);
    }

    private String obfuscated(String string) {
        return this.rot13(string);
    }

    private String rot13(String s) {
        StringBuilder rot13 = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c >= 'a' && c <= 'm') {
                c = (char)(c + 13);
            } else if (c >= 'A' && c <= 'M') {
                c = (char)(c + 13);
            } else if (c >= 'n' && c <= 'z') {
                c = (char)(c - 13);
            } else if (c >= 'N' && c <= 'Z') {
                c = (char)(c - 13);
            }
            rot13.append(c);
        }
        return rot13.toString();
    }
}

