/*
 * Decompiled with CFR 0.152.
 */
package com.github.toolarium.common;

import com.github.toolarium.common.util.ByteUtil;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;

public class ByteArray
implements Serializable,
WritableByteChannel,
ReadableByteChannel,
Cloneable {
    public static final ByteArray NL = new ByteArray("\n");
    public static final ByteArray CR = new ByteArray("\r");
    public static final ByteArray TAB = new ByteArray("\t");
    public static final ByteArray SPACE = new ByteArray(" ");
    public static final ByteArray DOT = new ByteArray(".");
    public static final ByteArray EMPTY = new ByteArray(1);
    public static final int DEFAULT_BLOCK_SIZE = 96;
    private static final long serialVersionUID = 3907211563424559664L;
    private byte[] bytes;
    private int length = 0;
    private boolean isOpen;

    private ByteArray(int size) {
        this.bytes = new byte[size];
        this.isOpen = true;
    }

    public ByteArray() {
        this(96);
    }

    public ByteArray(String data) {
        this(data == null ? 96 : data.length());
        if (data != null) {
            this.append(data);
        }
    }

    public ByteArray(StringBuilder data) {
        this(data == null ? 96 : data.length());
        if (data != null) {
            this.append(data);
        }
    }

    public ByteArray(StringBuffer data) {
        this(data == null ? 96 : data.length());
        if (data != null) {
            this.append(data);
        }
    }

    public ByteArray(ByteArray data) {
        this(data == null ? 96 : data.length());
        if (data != null) {
            this.append(data);
        }
    }

    public ByteArray(byte[] data) {
        this(data == null ? 96 : data.length);
        if (data != null) {
            this.append(data);
        }
    }

    public static ByteArray createByteArrayWithSize(int size) {
        if (size <= 1) {
            return new ByteArray(1);
        }
        return new ByteArray(size);
    }

    public static ByteArray createByteArray(byte b, int size) {
        ByteArray newArray;
        if (size <= 1) {
            newArray = new ByteArray(1);
            newArray.bytes[0] = b;
            newArray.length = 1;
            newArray.isOpen = true;
        } else {
            newArray = new ByteArray(size);
            newArray.append(b);
        }
        return newArray;
    }

    public static ByteArray createByteArray(ByteBuffer buffer) {
        if (buffer == null) {
            return null;
        }
        int count = buffer.remaining();
        if (count <= 0) {
            return null;
        }
        ByteArray newArray = new ByteArray(count);
        newArray.write(buffer);
        buffer.rewind();
        return newArray;
    }

    public ByteArray append(byte ch) {
        this.crowUpDataSize(1);
        this.bytes[this.length++] = ch;
        return this;
    }

    public ByteArray append(ByteArray data) {
        this.crowUpDataSize(data.length());
        System.arraycopy(data.bytes, 0, this.bytes, this.length, data.length());
        this.length += data.length();
        return this;
    }

    public ByteArray append(byte[] data) {
        if (data == null) {
            return this;
        }
        this.crowUpDataSize(data.length);
        System.arraycopy(data, 0, this.bytes, this.length, data.length);
        this.length += data.length;
        return this;
    }

    public ByteArray append(byte[] data, int off, int len) {
        this.crowUpDataSize(len);
        System.arraycopy(data, off, this.bytes, this.length, len);
        this.length += len;
        return this;
    }

    public ByteArray append(String data) {
        if (data != null) {
            this.append(data.getBytes());
        }
        return this;
    }

    public ByteArray append(StringBuilder data) {
        if (data != null) {
            this.append(data.toString().getBytes());
        }
        return this;
    }

    public ByteArray append(StringBuffer data) {
        if (data != null) {
            this.append(data.toString().getBytes());
        }
        return this;
    }

    public ByteArray append(ByteBuffer data) {
        while (data.hasRemaining()) {
            int size = data.remaining();
            byte[] d = new byte[size];
            data.get(d, 0, size);
            this.append(d);
        }
        data.rewind();
        return this;
    }

    public ByteArray reverse() {
        ByteArray array = new ByteArray(this.length());
        for (int i = this.length() - 1; i >= 0; --i) {
            array.append(this.get(i));
        }
        return array;
    }

    public ByteArray trim(byte ch) {
        this.trimRight(ch);
        this.trimLeft(ch);
        return this;
    }

    public ByteArray trimRight(byte ch) {
        if (this.bytes.length == 0) {
            return this;
        }
        int count = 0;
        for (int i = this.length - 1; i >= 0 && this.bytes[i] == ch; --i) {
            ++count;
        }
        this.chopRight(count);
        return this;
    }

    public ByteArray trimLeft(byte ch) {
        if (this.bytes.length == 0) {
            return this;
        }
        int count = 0;
        for (int i = 0; i < this.length && this.bytes[i] == ch; ++i) {
            ++count;
        }
        if (count == this.length) {
            this.length = 0;
        } else {
            ByteArray trimmed = this.getBytes(count, this.length);
            this.length = trimmed.length;
            this.bytes = trimmed.bytes;
        }
        return this;
    }

    public ByteArray replace(byte toReplace, byte newByte) {
        if (this.bytes.length == 0) {
            return this;
        }
        for (int i = 0; i < this.length; ++i) {
            if (this.bytes[i] != toReplace) continue;
            this.bytes[i] = newByte;
        }
        return this;
    }

    public ByteArray replace(ByteArray replaceData, ByteArray newData) {
        if (replaceData == null || replaceData.length() == 0) {
            return this;
        }
        if (newData == null) {
            return this;
        }
        ByteArray workData = new ByteArray();
        int maxLength = this.length();
        int len = replaceData.length();
        int start = 0;
        int end = this.indexOf(replaceData);
        while (start >= 0 && end >= 0) {
            workData.append(this.getBytes(start, end));
            workData.append(newData);
            start = end + len;
            end = this.indexOf(replaceData, start);
        }
        if (start < maxLength) {
            workData.append(this.getBytes(start, maxLength));
        }
        return workData;
    }

    public int indexOf(byte toFind) {
        if (this.bytes.length == 0) {
            return -1;
        }
        for (int i = 0; i < this.length; ++i) {
            if (this.bytes[i] != toFind) continue;
            return i;
        }
        return -1;
    }

    public int indexOf(ByteArray toFind) {
        if (this.bytes.length == 0) {
            return -1;
        }
        return this.indexOf(toFind, 0);
    }

    public int indexOf(ByteArray toFind, int fromIndex) {
        if (this.bytes.length == 0) {
            return -1;
        }
        return ByteUtil.getInstance().indexOf(this.bytes, 0, this.length, toFind.bytes, 0, toFind.length, fromIndex);
    }

    public int lastIndexOf(byte toFind) {
        if (this.bytes.length == 0) {
            return -1;
        }
        for (int i = this.length - 1; i >= 0; --i) {
            if (this.bytes[i] != toFind) continue;
            return i;
        }
        return -1;
    }

    public boolean startsWith(ByteArray prefix) {
        return this.startsWith(prefix, 0);
    }

    public boolean startsWith(ByteArray prefix, int toffset) {
        if (prefix == null || prefix.length == 0) {
            return false;
        }
        if (this.bytes.length == 0) {
            return false;
        }
        byte[] ta = this.bytes;
        int to = toffset;
        byte[] pa = prefix.bytes;
        int po = 0;
        int pc = prefix.length;
        if (toffset < 0 || toffset > this.length - pc) {
            return false;
        }
        while (--pc >= 0) {
            if (ta[to++] == pa[po++]) continue;
            return false;
        }
        return true;
    }

    public boolean startsWith(byte prefix) {
        if (this.bytes.length == 0) {
            return false;
        }
        return this.bytes[0] == prefix;
    }

    public int countStartsWith(ByteArray prefix) {
        if (prefix == null || prefix.length == 0) {
            return 0;
        }
        if (this.bytes.length == 0) {
            return 0;
        }
        int idx = prefix.length();
        int counter = 0;
        int offset = 0;
        while (idx > 0 && this.startsWith(prefix, offset)) {
            ++counter;
            offset += prefix.length;
        }
        return counter;
    }

    public boolean endsWith(byte prefix) {
        if (this.bytes.length == 0 || this.length <= 0) {
            return false;
        }
        return this.bytes[this.length - 1] == prefix;
    }

    public boolean endsWith(ByteArray prefix) {
        if (prefix == null || prefix.length == 0) {
            return false;
        }
        if (this.bytes.length == 0 || this.length <= 0) {
            return false;
        }
        return this.startsWith(prefix, this.length - prefix.length);
    }

    public int countEndsWith(ByteArray prefix) {
        if (prefix == null || prefix.length == 0) {
            return 0;
        }
        if (this.bytes.length == 0) {
            return 0;
        }
        int idx = prefix.length();
        int counter = 0;
        int offset = this.length - prefix.length;
        while (idx > 0 && this.startsWith(prefix, offset)) {
            ++counter;
            offset -= prefix.length;
        }
        return counter;
    }

    public String toHex() {
        StringBuffer hexNumber = new StringBuffer(this.bytes.length * 2);
        for (int i = 0; i < this.bytes.length; ++i) {
            String value = Long.toString(this.bytes[i] & 0xFF, 16);
            if (value.length() == 1) {
                value = "0" + value;
            }
            value = value.toUpperCase();
            hexNumber.append(value);
        }
        return hexNumber.toString();
    }

    public String toString() {
        return new String(this.bytes, 0, this.length);
    }

    public byte[] toBytes() {
        byte[] data = new byte[this.length];
        System.arraycopy(this.bytes, 0, data, 0, this.length);
        return data;
    }

    public long toLong() {
        return ByteUtil.getInstance().toLong(this.bytes);
    }

    public ByteBuffer toByteBuffer() {
        return ByteBuffer.wrap(this.bytes, 0, this.length);
    }

    public ByteArray toByteArray(int startPos, int endPos) {
        int start = 0;
        int end = this.length();
        if (startPos < 0) {
            start = 0;
        }
        if (startPos >= 0 && startPos <= this.length()) {
            start = startPos;
        }
        if (endPos < 0) {
            end = 0;
        } else if (endPos >= 0 && endPos <= this.length()) {
            end = endPos;
        }
        ByteArray array = null;
        if (start < end) {
            int len = end - start;
            array = new ByteArray(len + 1);
            array.isOpen = this.isOpen;
            array.length = len;
            System.arraycopy(this.bytes, start, array.bytes, 0, len);
        } else {
            array = new ByteArray();
        }
        return array;
    }

    public ByteArray getBytes() {
        return new ByteArray(this.toBytes());
    }

    public ByteArray getBytes(int startPos, int endPos) {
        ByteArray array;
        int start = 0;
        int end = this.length();
        if (startPos < 0) {
            start = 0;
        }
        if (startPos >= 0 && startPos <= this.length()) {
            start = startPos;
        }
        if (endPos < 0) {
            end = 0;
        } else if (endPos >= 0 && endPos <= this.length()) {
            end = endPos;
        }
        if (start < end) {
            int len = end - start;
            array = new ByteArray(len + 1);
            System.arraycopy(this.bytes, start, array.bytes, 0, len);
            array.length = len;
        } else {
            array = new ByteArray();
        }
        return array;
    }

    public ByteArray concat(byte b) {
        byte[] r = this.toBytes();
        ByteArray array = new ByteArray(r.length + 1);
        array.append(r);
        array.append(b);
        return array;
    }

    public ByteArray concat(ByteArray b) {
        byte[] r = this.toBytes();
        ByteArray array = new ByteArray(r.length + b.length());
        array.append(r);
        array.append(b);
        return array;
    }

    public byte get(int pos) throws ArrayIndexOutOfBoundsException {
        if (pos < this.length()) {
            return this.bytes[pos];
        }
        throw new ArrayIndexOutOfBoundsException("Invalid position at " + pos + " (length:" + this.length + ")!");
    }

    public byte set(int pos, byte b) throws ArrayIndexOutOfBoundsException {
        if (pos < this.length()) {
            byte result = this.bytes[pos];
            this.bytes[pos] = b;
            return result;
        }
        throw new ArrayIndexOutOfBoundsException("Invalid position at " + pos + "!");
    }

    public int length() {
        return this.length;
    }

    public ByteArray erase() {
        this.length = 0;
        return this;
    }

    public ByteArray chopRight() {
        return this.chopRight(1);
    }

    public ByteArray chopRight(int num) {
        this.length -= num;
        if (this.length < 0) {
            this.length = 0;
        }
        return this;
    }

    public ByteArray chopLeft() {
        return this.chopLeft(1);
    }

    public ByteArray chopLeft(int num) {
        if (num <= this.length) {
            System.arraycopy(this.bytes, num, this.bytes, 0, this.length - num);
            this.length -= num;
        } else {
            this.erase();
        }
        return this;
    }

    @Override
    public int write(ByteBuffer src) {
        if (!this.isOpen || src == null || !src.hasRemaining()) {
            return 0;
        }
        int size = src.remaining();
        if (size <= 0) {
            return 0;
        }
        byte[] d = new byte[size];
        src.get(d);
        this.append(d);
        return size;
    }

    @Override
    public void close() {
        this.isOpen = false;
    }

    @Override
    public boolean isOpen() {
        return this.isOpen;
    }

    @Override
    public int read(ByteBuffer dst) {
        if (!this.isOpen || dst == null || this.length() == 0) {
            return 0;
        }
        dst.put(this.bytes, 0, this.length);
        return this.length;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (other.getClass() != this.getClass()) {
            return false;
        }
        ByteArray b2 = (ByteArray)other;
        if (this.length() != b2.length()) {
            return false;
        }
        byte[] bytes2 = b2.bytes;
        for (int i = 0; i < this.length(); ++i) {
            if (this.bytes[i] == bytes2[i]) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        if (this.bytes.length == 0) {
            return 0;
        }
        int off = 0;
        int len = this.length;
        int hash = 0;
        for (int i = 0; i < len; ++i) {
            hash = 31 * hash + this.bytes[off++];
        }
        return hash;
    }

    public ByteArray clone() {
        return new ByteArray(this);
    }

    protected void crowUpDataSize(int requestedSpace) {
        if (this.bytes.length - this.length < requestedSpace) {
            byte[] tmpbytes = this.bytes;
            this.bytes = new byte[this.getNewDataSize(requestedSpace)];
            System.arraycopy(tmpbytes, 0, this.bytes, 0, this.length);
        }
    }

    protected int getNewDataSize(int requestedSpace) {
        int size = 0;
        if (this.bytes != null) {
            size = this.bytes.length;
        }
        int minLen = requestedSpace + size;
        int rest = 96 - minLen % 96;
        return minLen + rest;
    }
}

