/*
 * Decompiled with CFR 0.152.
 */
package com.github.toolarium.common.security;

import com.github.toolarium.common.security.ISecuredValue;
import java.util.Objects;

public class SecuredValue<T>
implements ISecuredValue<T> {
    private static final long serialVersionUID = -7130513492378872813L;
    private T value;
    private String securedValue;

    public SecuredValue(T value) {
        this.setValue(value, "...");
    }

    public SecuredValue(T value, String securedValue) {
        this.setValue(value, securedValue);
    }

    @Override
    public T getValue() {
        return this.value;
    }

    public SecuredValue<T> setValue(T value) {
        this.value = value;
        this.securedValue = null;
        return this;
    }

    public SecuredValue<T> setValue(T value, String securedValue) {
        this.value = value;
        this.securedValue = securedValue;
        return this;
    }

    @Override
    public boolean hasSecuredValue() {
        return this.securedValue != null;
    }

    @Override
    public String getSecuredValue() {
        return this.securedValue;
    }

    public int hashCode() {
        return Objects.hash(this.securedValue, this.value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SecuredValue other = (SecuredValue)obj;
        return Objects.equals(this.securedValue, other.securedValue) && Objects.equals(this.value, other.value);
    }

    public String toString() {
        if (this.hasSecuredValue()) {
            return this.securedValue;
        }
        if (this.value == null) {
            return "";
        }
        return "" + this.value;
    }
}

