/*
 * Decompiled with CFR 0.152.
 */
package com.github.toolarium.common.util;

import com.github.toolarium.common.ByteArray;
import java.io.ByteArrayOutputStream;
import java.math.BigInteger;

public final class ByteUtil {
    private ByteUtil() {
    }

    public static ByteUtil getInstance() {
        return HOLDER.INSTANCE;
    }

    public boolean equalsBlock(byte[] dataA, int offsetDataA, byte[] dataB, int offsetDataB, int len) {
        try {
            for (int i = 0; i < len; ++i) {
                if (dataA[offsetDataA + i] == dataB[offsetDataB + i]) continue;
                return false;
            }
        }
        catch (Exception ex) {
            return false;
        }
        return true;
    }

    public boolean equalsBlock(byte[] a, byte[] b) {
        if (a.length == b.length) {
            return this.equalsBlock(a, 0, b, 0, a.length);
        }
        return false;
    }

    public byte[] toByteArray(String s) {
        int n = s.length();
        int b1 = -1;
        int b2 = -1;
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        for (int i = 0; i < n; ++i) {
            if (b1 == -1) {
                b1 = this.toByte(s.charAt(i), 16);
            } else {
                b2 = this.toByte(s.charAt(i), 16);
            }
            if (b1 == -1 || b2 == -1) continue;
            bout.write(b1 << 4 | b2);
            b1 = -1;
            b2 = -1;
        }
        return bout.toByteArray();
    }

    public int toByte(char c, int radix) {
        int b = c >= '0' && c <= '9' ? c - 48 : (c >= 'A' && c <= 'Z' ? c - 65 + 10 : (c >= 'a' && c <= 'z' ? c - 97 + 10 : -1));
        if (b < 0 || b >= radix) {
            return -1;
        }
        return b;
    }

    public void copyBlock(byte[] src, int srcOff, byte[] dst, int dstOff, int len) {
        for (int i = 0; i < len; ++i) {
            dst[dstOff + i] = src[srcOff + i];
        }
    }

    public void copyBlock(byte[] src, byte[] dst) {
        for (int i = 0; i < src.length; ++i) {
            dst[i] = src[i];
        }
    }

    public void copyBlock(int[] src, int srcOff, int[] dst, int dstOff, int len) {
        for (int i = 0; i < len; ++i) {
            dst[dstOff + i] = src[srcOff + i];
        }
    }

    public void copyBlock(int[] src, int[] dst) {
        for (int i = 0; i < src.length; ++i) {
            dst[i] = src[i];
        }
    }

    public byte[] toBytes(int inputSrc) {
        int src = inputSrc;
        byte[] dest = new byte[]{(byte)(src & 0xFF), (byte)((src >>= 8) & 0xFF), (byte)((src >>= 8) & 0xFF), (byte)((src >>= 8) & 0xFF)};
        return dest;
    }

    public byte[] toBytes(long src) {
        return BigInteger.valueOf(src).toByteArray();
    }

    public byte[] toBytes(byte[] src, int len) {
        if (src.length % len == 0) {
            return src;
        }
        int size = len * (src.length / len + 1);
        int diff = size - src.length;
        byte[] result = new byte[size];
        for (int i = 0; i < size; ++i) {
            result[i] = 0;
        }
        this.copyBlock(src, 0, result, diff, src.length);
        return result;
    }

    public int toInteger(ByteArray src) {
        if (src == null) {
            return 0;
        }
        return this.toInteger(src.toBytes());
    }

    public int toInteger(byte[] src) {
        if (src == null) {
            return 0;
        }
        int result = src[0] & 0xFF;
        result |= (src[1] & 0xFF) << 8;
        if (src.length > 2) {
            result |= (src[2] & 0xFF) << 16;
            if (src.length > 3) {
                result |= (src[3] & 0xFF) << 24;
            }
        }
        return result;
    }

    public long toLong(byte[] src) {
        if (src == null) {
            return 0L;
        }
        return new BigInteger(src).longValue();
    }

    public long toLong(ByteArray src) {
        if (src == null) {
            return 0L;
        }
        return ByteUtil.getInstance().toLong(src.toBytes());
    }

    public int indexOf(byte[] source, int sourceOffset, int sourceCount, byte[] target, int targetOffset, int targetCount, int index) {
        int fromIndex = index;
        if (fromIndex >= sourceCount) {
            if (targetCount == 0) {
                return sourceCount;
            }
            return -1;
        }
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        if (targetCount == 0) {
            return fromIndex;
        }
        byte first = target[targetOffset];
        int i = sourceOffset + fromIndex;
        int max = sourceOffset + (sourceCount - targetCount);
        block0: while (true) {
            if (i <= max && source[i] != first) {
                ++i;
                continue;
            }
            if (i > max) {
                return -1;
            }
            int j = i + 1;
            int end = j + targetCount - 1;
            int k = targetOffset + 1;
            while (j < end) {
                if (source[j++] == target[k++]) continue;
                ++i;
                continue block0;
            }
            break;
        }
        return i - sourceOffset;
    }

    private static class HOLDER {
        static final ByteUtil INSTANCE = new ByteUtil();

        private HOLDER() {
        }
    }
}

