/*
 * Decompiled with CFR 0.152.
 */
package com.github.toolarium.common.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.security.DigestInputStream;
import java.security.MessageDigest;

public final class ChannelUtil {
    private ChannelUtil() {
    }

    public static ChannelUtil getInstance() {
        return HOLDER.INSTANCE;
    }

    public long channelCopy(InputStream src, OutputStream dest) throws IOException {
        return this.channelCopy(src, dest, null);
    }

    public long channelCopy(ReadableByteChannel src, WritableByteChannel dest) throws IOException {
        ByteBuffer buffer = ByteBuffer.allocate(4096);
        long size = 0L;
        while (src.read(buffer) != -1) {
            buffer.flip();
            size += (long)dest.write(buffer);
            buffer.compact();
        }
        buffer.flip();
        while (buffer.hasRemaining()) {
            size += (long)dest.write(buffer);
        }
        return size;
    }

    public long channelCopy(InputStream src, OutputStream dest, MessageDigest messageDigest) throws IOException {
        ReadableByteChannel inChannel = null;
        inChannel = messageDigest != null ? Channels.newChannel(new DigestInputStream(src, messageDigest)) : Channels.newChannel(src);
        WritableByteChannel outChannel = Channels.newChannel(dest);
        return this.channelCopy(inChannel, outChannel);
    }

    private static class HOLDER {
        static final ChannelUtil INSTANCE = new ChannelUtil();

        private HOLDER() {
        }
    }
}

