/*
 * Decompiled with CFR 0.152.
 */
package com.github.toolarium.common.util;

import com.github.toolarium.common.util.ReflectionUtil;

public final class ClassInstanceUtil {
    private ClassInstanceUtil() {
    }

    public static ClassInstanceUtil getInstance() {
        return HOLDER.INSTANCE;
    }

    public <T> Class<T> getClassObject(String className) throws ClassNotFoundException {
        return ReflectionUtil.getInstance().getClassObject(className);
    }

    public <T> T newInstance(String className) throws ClassNotFoundException, InstantiationException, IllegalAccessException, SecurityException {
        Class<T> resultClass = this.getClassObject(className);
        T obj = null;
        if (resultClass != null) {
            obj = this.newInstance(resultClass);
        }
        if (obj == null) {
            throw new ClassNotFoundException("Could not load class " + className);
        }
        return obj;
    }

    public <T> T newInstance(Class<T> clazz) throws SecurityException, InstantiationException, IllegalAccessException {
        return ReflectionUtil.getInstance().newInstance(clazz);
    }

    public <T> T[] createArray(Class<T> theClass, int length) {
        if (theClass == null || length <= 0) {
            throw new IllegalArgumentException("Invalid data to create an array!");
        }
        Object[] array = new Object[length];
        return array;
    }

    public boolean isClassAvailable(String className) {
        try {
            Class.forName(className);
            return true;
        }
        catch (Exception | NoClassDefFoundError e) {
            return false;
        }
    }

    public boolean implementsInterface(String className, Class<?> interfaceClazz) {
        if (className == null || className.trim().isEmpty()) {
            return false;
        }
        try {
            Class clazz = this.getClassObject(className);
            if (clazz == null) {
                return false;
            }
            return interfaceClazz.isAssignableFrom(clazz);
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    private static class HOLDER {
        static final ClassInstanceUtil INSTANCE = new ClassInstanceUtil();

        private HOLDER() {
        }
    }
}

