/*
 * Decompiled with CFR 0.152.
 */
package com.github.toolarium.common.util;

import com.github.toolarium.common.util.ChannelUtil;
import com.github.toolarium.common.util.StringUtil;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;

public final class FileUtil {
    public static final char SLASH = '/';
    public static final char BACKSLASH = '\\';
    public static final String SLASH_STR = "/";
    public static final String BACKSLASH_STR = "\\";

    private FileUtil() {
    }

    public static FileUtil getInstance() {
        return HOLDER.INSTANCE;
    }

    public String simplifyPath(String path) {
        if (path == null) {
            return null;
        }
        String result = path.trim();
        if (result.length() == 0) {
            return result;
        }
        result = StringUtil.getInstance().trimRight(result.replace('\\', '/'), '/');
        List<String> pathList = StringUtil.getInstance().splitAsList(result, SLASH_STR);
        int i = 0;
        while (i >= 0 && i < pathList.size()) {
            String pathElement = pathList.get(i);
            if ("..".equals(pathElement)) {
                if (i - 1 >= 0) {
                    pathList.remove(i - 1);
                }
                if (i - 1 >= 0) {
                    pathList.remove(i - 1);
                }
                --i;
                continue;
            }
            ++i;
        }
        result = "";
        for (String p : pathList) {
            if (result.length() == 0) {
                result = p;
                continue;
            }
            result = result + SLASH_STR + p;
        }
        if (path.endsWith(SLASH_STR) && !result.endsWith(SLASH_STR)) {
            result = result + SLASH_STR;
        }
        if (path.startsWith(SLASH_STR) && !result.startsWith(SLASH_STR)) {
            result = SLASH_STR + result;
        }
        return result;
    }

    public String slashify(String path) {
        File f;
        if (path == null || path.isEmpty()) {
            return "";
        }
        String p = path;
        if (File.separatorChar != '/') {
            p = p.replace(File.separatorChar, '/');
        }
        if (!p.startsWith(SLASH_STR) && !p.substring(1, 2).equals(":")) {
            p = SLASH_STR + p;
        }
        if ((f = new File(p)).isDirectory() && !p.endsWith(SLASH_STR) && f.isDirectory()) {
            p = p + SLASH_STR;
        }
        int end = p.length();
        if (p.length() > 0) {
            for (int i = p.length() - 1; i > 0; --i) {
                if (p.charAt(i) != '/' || p.charAt(i - 1) != '/') continue;
                end = i;
            }
            if (p.length() > end) {
                p = p.substring(0, end);
            }
        }
        return p;
    }

    public boolean existFile(String fileName) {
        if (fileName == null) {
            return false;
        }
        return new File(fileName).exists();
    }

    public boolean isReadable(String fileName) {
        if (fileName == null) {
            return false;
        }
        File fileToCheck = new File(fileName);
        return fileToCheck.exists() && fileToCheck.canRead();
    }

    public boolean isWritable(String fileName) {
        if (fileName == null) {
            return false;
        }
        File fileToCheck = new File(fileName);
        return fileToCheck.exists() && fileToCheck.canWrite();
    }

    public boolean removeFile(String fileName) {
        if (fileName == null) {
            return false;
        }
        return this.removeFile(new File(fileName));
    }

    public boolean removeFile(File file) {
        if (file == null) {
            return false;
        }
        if (file.delete()) {
            return true;
        }
        System.gc();
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
        return file.delete();
    }

    public boolean removeDirectory(Path dir) {
        return this.removeDirectory(dir.toFile());
    }

    public boolean removeDirectory(File dir) {
        if (dir == null) {
            return false;
        }
        if (dir.isDirectory()) {
            String[] children = dir.list();
            for (int i = 0; i < children.length; ++i) {
                boolean success = this.removeDirectory(new File(dir, children[i]));
                if (success) continue;
                return false;
            }
        }
        return this.removeFile(dir);
    }

    public String extractURLPath(URL url) {
        if (url == null) {
            return null;
        }
        String result = "" + new File(url.getPath());
        result = result.replace(BACKSLASH_STR, SLASH_STR);
        int lastIndex = (result = result.replace("file:/", "")).indexOf(33);
        if (lastIndex > 0) {
            result = result.substring(0, lastIndex);
        }
        if (!result.startsWith(SLASH_STR) && (lastIndex = result.indexOf(58)) < 0) {
            result = SLASH_STR + result;
        }
        return result;
    }

    public String readFileContent(File file) throws IOException {
        return this.readFileContent(file, StandardCharsets.UTF_8);
    }

    public String readFileContent(Path file) throws IOException {
        return this.readFileContent(file, StandardCharsets.UTF_8);
    }

    public String readFileContent(File file, Charset charset) throws IOException {
        if (file == null) {
            return null;
        }
        return this.readFileContent(file.toPath(), StandardCharsets.UTF_8);
    }

    public String readFileContent(Path file, Charset charset) throws IOException {
        return new String(Files.readAllBytes(file), charset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String readFileContent(URL url) throws IOException {
        if (url == null) {
            return "";
        }
        try (InputStream src = null;){
            ByteArrayOutputStream dest = new ByteArrayOutputStream();
            src = url.openStream();
            ChannelUtil.getInstance().channelCopy(src, dest);
            String string = dest.toString();
            return string;
        }
    }

    public void writeFileContent(Path file, String content) throws IOException {
        this.writeFileContent(file, StandardCharsets.UTF_8, content);
    }

    public void writeFileContent(File file, String content) throws IOException {
        this.writeFileContent(file.toPath(), StandardCharsets.UTF_8, content);
    }

    public void writeFileContent(File file, Charset charset, String content) throws IOException {
        this.writeFileContent(file.toPath(), charset, content);
    }

    public void writeFileContent(Path file, Charset charset, String content) throws IOException {
        Files.write(file, content.getBytes(charset), new OpenOption[0]);
    }

    private static class HOLDER {
        static final FileUtil INSTANCE = new FileUtil();

        private HOLDER() {
        }
    }
}

