/*
 * Decompiled with CFR 0.152.
 */
package com.github.toolarium.common.util;

import com.github.toolarium.common.util.PropertyExpanderContextBasedProperties;
import java.util.Properties;

public final class PropertyExpander {
    private static PropertyExpander instance = new PropertyExpander();

    private PropertyExpander() {
    }

    public static PropertyExpander getInstance() {
        return instance;
    }

    public String expand(String expression) {
        if (expression == null) {
            return null;
        }
        ExpanderContext context = new ExpanderContext(expression);
        return this.readTermExpression(context);
    }

    private String readTermExpression(ExpanderContext context) {
        int lastPosition = -1;
        boolean positionChange = true;
        String result = "";
        while (!context.isEnd() && positionChange) {
            result = result + this.readTerm(context);
            if (!context.isEnd()) {
                result = result + this.readBlanks(context);
            }
            positionChange = lastPosition != context.getPosition();
            lastPosition = context.getPosition();
        }
        return result;
    }

    private String readTerm(ExpanderContext context) {
        if (context.startEnvExperession()) {
            return this.readEnvExpression(context);
        }
        return this.readAttribute(context, true);
    }

    private String readBlanks(ExpanderContext context) {
        String result = "";
        Character c = context.getCurrent();
        while (c != null && c.charValue() == ' ') {
            result = result + c;
            c = context.readNext();
        }
        return result;
    }

    private String readAttribute(ExpanderContext context, boolean ignoreExpandEndCharacter) {
        String result = "";
        Character c = context.getCurrent();
        while (c != null && c.charValue() != ' ' && c.charValue() != '$' && (ignoreExpandEndCharacter || !ignoreExpandEndCharacter && c.charValue() != '}')) {
            result = result + c;
            c = context.readNext();
        }
        return result;
    }

    private String readEnvAttributeName(ExpanderContext context) {
        String result = "";
        Character c = context.getCurrent();
        while (c != null && c.charValue() != ' ' && c.charValue() != '$' && c.charValue() != '{' && c.charValue() != '}') {
            result = result + c;
            c = context.readNext();
        }
        return result;
    }

    String readEnvExpression(ExpanderContext context) {
        String s;
        Character c = context.getCurrent();
        if (c.charValue() != '$') {
            return this.readAttribute(context, false);
        }
        String envExpression = "" + c;
        String envTag = "";
        c = context.readNext();
        if (c != null && c.charValue() == '{') {
            envExpression = envExpression + c;
            c = context.readNext();
            this.readBlanks(context);
            envTag = envTag + this.readEnvAttributeName(context);
            envExpression = envExpression + envTag;
            this.readBlanks(context);
            if (!context.isEnd()) {
                c = context.getCurrent();
            }
            if (c != null) {
                if (c.charValue() != '}') {
                    return envExpression;
                }
                envExpression = envExpression + c;
            }
            if (!context.isEnd()) {
                c = context.readNext();
            }
        } else {
            envTag = this.readAttribute(context, false);
            envExpression = envExpression + envTag;
        }
        if ((s = this.resolveProperty(envTag, envExpression)).equals("${}")) {
            s = "";
        }
        return s;
    }

    private String resolveProperty(String tag, String defaultValue) {
        if (tag == null || tag.isEmpty()) {
            return defaultValue;
        }
        String result = defaultValue;
        String propEnv = null;
        Properties prop = PropertyExpanderContextBasedProperties.get();
        if (prop != null) {
            propEnv = prop.getProperty(tag);
        }
        if (propEnv == null || propEnv.isEmpty()) {
            propEnv = System.getProperty(tag);
        }
        if (propEnv == null || propEnv.isEmpty()) {
            propEnv = System.getenv().get(tag);
        }
        if (propEnv != null && !propEnv.isEmpty()) {
            result = propEnv;
        }
        return result;
    }

    final class ExpanderContext {
        private static final char BLANK = ' ';
        private static final char START_ENV_CHARACTER = '$';
        private static final char START_EXPAND_CHARACTER = '{';
        private static final char END_EXPAND_CHARACTER = '}';
        private String expression;
        private int currentPosition;

        ExpanderContext(String expression) {
            this.expression = expression;
            this.currentPosition = 0;
        }

        boolean isEnd() {
            return this.expression == null || this.expression.length() == this.currentPosition;
        }

        boolean startEnvExperession() {
            return this.expression.charAt(this.currentPosition) == '$';
        }

        Character getCurrent() {
            if (this.isEnd()) {
                return null;
            }
            return Character.valueOf(this.expression.charAt(this.currentPosition));
        }

        Character readNext() {
            if (this.isEnd()) {
                return null;
            }
            ++this.currentPosition;
            return this.getCurrent();
        }

        int getPosition() {
            return this.currentPosition;
        }

        public String toString() {
            return this.expression;
        }
    }
}

