/*
 * Decompiled with CFR 0.152.
 */
package com.github.toolarium.common.util;

import com.github.toolarium.common.ByteArray;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.util.Date;

public final class RandomGenerator {
    public static final char[] validNumberCharacters = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
    public static final char[] validLowerCaseLetterCharacters = new char[]{'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'};
    public static final char[] validUpperCaseLetterCharacters = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z'};
    public static final char[] validLetterCharacters = RandomGenerator.combineValidCharacters(validLowerCaseLetterCharacters, validUpperCaseLetterCharacters);
    public static final char[] validNumberLetterCharacters = RandomGenerator.combineValidCharacters(validNumberCharacters, validLetterCharacters);
    public static final long ONE_DAY = 86400000L;
    private SecureRandom secureRandom = new SecureRandom();
    private String sid;

    private RandomGenerator() {
    }

    public static RandomGenerator getInstance() {
        return HOLDER.INSTANCE;
    }

    public static synchronized RandomGenerator getInstance(SecureRandom random) {
        RandomGenerator instance = RandomGenerator.getInstance();
        instance.secureRandom = random;
        return instance;
    }

    public synchronized SecureRandom getSecureRandom() {
        return this.secureRandom;
    }

    public synchronized Boolean getBooleanRandom() {
        return this.secureRandom.nextBoolean();
    }

    public synchronized Integer getIntegerRandom() {
        return this.secureRandom.nextInt();
    }

    public synchronized Long getLongRandom() {
        return this.secureRandom.nextLong();
    }

    public synchronized Float getFloatRandom() {
        return Float.valueOf(this.secureRandom.nextFloat());
    }

    public synchronized Double getDoubleRandom() {
        return this.secureRandom.nextDouble();
    }

    public ByteArray getRandomByteArray(int size) {
        return new ByteArray(this.nextBytes(size));
    }

    public String getRandomString(int size) {
        return new String(this.nextBytes(size));
    }

    public synchronized String getRandomString(int size, char[] validCharacters) {
        StringBuffer randomString = new StringBuffer();
        byte[] bytes = new byte[1];
        block0: while (randomString.length() < size) {
            this.getRandomNumber(validCharacters.length, true);
            this.secureRandom.nextBytes(bytes);
            for (int i = 0; i < validCharacters.length; ++i) {
                if ((char)bytes[0] != validCharacters[i]) continue;
                randomString.append((char)bytes[0]);
                continue block0;
            }
        }
        return randomString.toString();
    }

    public synchronized byte[] nextBytes(int size) {
        byte[] bytes = new byte[size];
        this.secureRandom.nextBytes(bytes);
        return bytes;
    }

    public String createGUID() {
        this.initializeSID();
        StringBuffer guid = new StringBuffer();
        guid.append(this.sid);
        guid.append(":");
        guid.append(Long.toString(System.currentTimeMillis()));
        guid.append(":");
        guid.append(Long.toString(this.getLongRandom()));
        try {
            StringBuffer result = new StringBuffer();
            MessageDigest msgDigest = MessageDigest.getInstance("sha-256");
            msgDigest.update(guid.toString().getBytes());
            byte[] array = msgDigest.digest();
            for (int j = 0; j < array.length; ++j) {
                int b = array[j] & 0xFF;
                if (b < 16) {
                    result.append('0');
                }
                result.append(Integer.toHexString(b));
            }
            return result.toString();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String createUUID() {
        String guid = this.createGUID();
        return "" + guid.substring(0, 8) + "-" + guid.substring(8, 12) + "-" + guid.substring(12, 16) + "-" + guid.substring(16, 20) + "-" + guid.substring(20);
    }

    public Date getRandomDayInFuture(int dayRange) {
        return new Date(new Date().getTime() + this.getRandomNumber(dayRange, false) * 86400000L);
    }

    public Date getRandomDateInFuture(long milisecondRange) {
        return new Date(new Date().getTime() + this.getRandomNumber(milisecondRange, false));
    }

    public Date getRandomDayInPast(int dayRange) {
        return new Date(new Date().getTime() - this.getRandomNumber(dayRange, false) * 86400000L);
    }

    public Date getRandomDateInPast(long milisecondRange) {
        return new Date(new Date().getTime() - this.getRandomNumber(milisecondRange, false));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getRandomNumber(long range, boolean allowZero) {
        long s = range;
        if (s < 0L) {
            s *= -1L;
        }
        if (range == 0L) {
            if (!allowZero) {
                return 1L;
            }
            return 0L;
        }
        if (range == 1L && !allowZero) {
            return 1L;
        }
        long r = -1L;
        if (allowZero) {
            ++s;
        }
        SecureRandom secureRandom = this.secureRandom;
        synchronized (secureRandom) {
            while (r <= 0L) {
                r = Math.abs(this.secureRandom.nextLong() % s);
            }
        }
        if (allowZero) {
            --r;
        }
        return r;
    }

    public float chisQuare(int number, int size) {
        int i;
        int t = 0;
        int[] f = new int[size];
        byte[] init = new byte[]{1, 2, 3, 4, 5, 6, 7};
        SecureRandom x = new SecureRandom(init);
        for (i = 0; i < number; ++i) {
            int n = x.nextInt(size);
            f[n] = f[n] + 1;
        }
        for (i = 0; i < size; ++i) {
            t += f[i] * f[i];
        }
        return size * t / number - number;
    }

    public static char[] combineValidCharacters(char[] input, char[] input2) {
        int i;
        char[] result = new char[input.length + input2.length];
        int pos = 0;
        for (i = 0; i < input.length; ++i) {
            result[pos++] = input[i];
        }
        for (i = 0; i < input2.length; ++i) {
            result[pos++] = input2[i];
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeSID() {
        if (this.sid == null) {
            RandomGenerator randomGenerator = this;
            synchronized (randomGenerator) {
                if (this.sid == null) {
                    try {
                        this.sid = InetAddress.getLocalHost().toString();
                    }
                    catch (UnknownHostException unknownHostException) {
                        // empty catch block
                    }
                }
            }
        }
    }

    private static class HOLDER {
        static final RandomGenerator INSTANCE = new RandomGenerator();

        private HOLDER() {
        }
    }
}

