/*
 * Decompiled with CFR 0.152.
 */
package com.github.toolarium.common.util;

import com.github.toolarium.common.util.ClassInstanceUtil;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public final class ReflectionUtil {
    private volatile boolean defaultDisabledAccessWarnings = false;
    private volatile boolean disabledAccessWarnings = false;

    private ReflectionUtil() {
        String prop = System.getProperty("disabledAccessWarnings");
        if (prop != null && prop.trim().equalsIgnoreCase("true")) {
            this.defaultDisabledAccessWarnings = true;
        }
    }

    public static ReflectionUtil getInstance() {
        return HOLDER.INSTANCE;
    }

    public boolean isClassAvailable(String className) throws IllegalArgumentException {
        if (className == null || className.isEmpty() || className.trim().isEmpty()) {
            throw new IllegalArgumentException("Invalid class name!");
        }
        try {
            this.disableAccessWarnings();
            Class.forName(className, false, ClassInstanceUtil.class.getClassLoader());
            return true;
        }
        catch (Exception | NoClassDefFoundError e) {
            return false;
        }
    }

    public <T> Class<T> getClassObject(String className) throws IllegalArgumentException, ClassNotFoundException {
        if (className == null || className.isEmpty() || className.trim().isEmpty()) {
            throw new IllegalArgumentException("Invalid class name!");
        }
        this.disableAccessWarnings();
        Class<?> resultCalss = Class.forName(className.trim());
        return resultCalss;
    }

    public <T> T newInstance(Class<T> clazz) throws IllegalArgumentException, SecurityException, InstantiationException, IllegalAccessException {
        if (clazz == null) {
            throw new IllegalArgumentException("Invalid empty class!");
        }
        try {
            this.disableAccessWarnings();
            Constructor<T> constructor = clazz.getDeclaredConstructor(new Class[0]);
            constructor.setAccessible(true);
            return constructor.newInstance(new Object[0]);
        }
        catch (NoSuchMethodException | InvocationTargetException e) {
            InstantiationException ex = new InstantiationException(e.getMessage());
            ex.setStackTrace(e.getStackTrace());
            throw ex;
        }
    }

    public <T> Method getMethod(String className, String methodName, Class<?>[] paramType) throws SecurityException, NoSuchMethodException, ClassNotFoundException {
        if (className == null) {
            throw new IllegalArgumentException("Invalid empty class name!");
        }
        if (methodName == null) {
            throw new IllegalArgumentException("Invalid empty method name!");
        }
        Class<T> clazz = this.getClassObject(className);
        return clazz.getMethod(methodName, paramType);
    }

    public <T> Object callMethod(Object classInstance, String className, String methodName, Class<?>[] paramType, Object[] param) throws SecurityException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException, ClassNotFoundException {
        Method method = this.getMethod(className, methodName, paramType);
        return method.invoke(classInstance, param);
    }

    public void disableAccessWarnings() {
        if (this.defaultDisabledAccessWarnings == this.disabledAccessWarnings) {
            return;
        }
        try {
            Class<?> unsafeClass = Class.forName("sun.misc.Unsafe");
            Field field = unsafeClass.getDeclaredField("theUnsafe");
            field.setAccessible(true);
            Object unsafe = field.get(null);
            Method putObjectVolatile = unsafeClass.getDeclaredMethod("putObjectVolatile", Object.class, Long.TYPE, Object.class);
            Method staticFieldOffset = unsafeClass.getDeclaredMethod("staticFieldOffset", Field.class);
            Class<?> loggerClass = Class.forName("jdk.internal.module.IllegalAccessLogger");
            Field loggerField = loggerClass.getDeclaredField("logger");
            Long offset = (Long)staticFieldOffset.invoke(unsafe, loggerField);
            putObjectVolatile.invoke(unsafe, loggerClass, offset, null);
            this.disabledAccessWarnings = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static class HOLDER {
        static final ReflectionUtil INSTANCE = new ReflectionUtil();

        private HOLDER() {
        }
    }
}

