/*
 * Decompiled with CFR 0.152.
 */
package com.github.toolarium.common.util;

import java.util.ArrayList;
import java.util.List;

public final class StringUtil {
    private static final char[] CAMEL_CASE_STOP_CHARACTERS = new char[]{'.', '_', ' '};
    private static final char[] hexDigits = "0123456789ABCDEF".toCharArray();

    private StringUtil() {
    }

    public static StringUtil getInstance() {
        return HOLDER.INSTANCE;
    }

    public StringBuilder newStringBuilder(CharSequence input, int num) {
        if (input == null) {
            return null;
        }
        StringBuilder buffer = new StringBuilder(num * input.length() + 1);
        for (int j = 0; j < num; ++j) {
            buffer.append(input);
        }
        return buffer;
    }

    public StringBuilder newStringBuilder(char character, int num) {
        if (num <= 0) {
            return new StringBuilder();
        }
        StringBuilder result = new StringBuilder(num + 1);
        for (int i = 0; i < num; ++i) {
            result.append(character);
        }
        return result;
    }

    public String newString(CharSequence input, int num) {
        StringBuilder result = this.newStringBuilder(input, num);
        if (result == null) {
            return null;
        }
        return result.toString();
    }

    public String newString(char character, int num) {
        StringBuilder result = this.newStringBuilder(character, num);
        if (result == null) {
            return null;
        }
        return result.toString();
    }

    public String width(CharSequence text, int width) {
        return this.width(text, width, ' ', true);
    }

    public String width(CharSequence text, int width, char fillupChar, boolean cutRight) {
        StringBuilder result = new StringBuilder();
        if (width <= 0) {
            return result.toString();
        }
        if (text != null) {
            result.append(text);
        }
        if (result.length() > width) {
            if (cutRight) {
                return result.substring(0, width);
            }
            return result.substring(result.length() - width, result.length());
        }
        result.append((CharSequence)this.newStringBuilder(fillupChar, width - result.length()));
        return result.toString();
    }

    public int countCharacters(String input, char ch) {
        if (input == null || input.isEmpty()) {
            return 0;
        }
        int result = 0;
        for (int i = 0; i < input.length(); ++i) {
            if (input.charAt(i) != ch) continue;
            ++result;
        }
        return result;
    }

    public int countEndingCharacter(String input, char ch) {
        if (input == null || input.isEmpty()) {
            return 0;
        }
        int idx = input.length();
        int counter = 0;
        while (idx > 0 && input.charAt(--idx) == ch) {
            ++counter;
        }
        return counter;
    }

    public String trimRight(String data) {
        return this.trimRight(data, ' ');
    }

    public String trimRight(String data, char ch) {
        if (data == null) {
            return null;
        }
        int len = data.length() - 1;
        int occurrence = 0;
        for (int i = len; i >= 0 && data.charAt(i) == ch; --i) {
            ++occurrence;
        }
        if (occurrence == 0) {
            return data;
        }
        return data.substring(0, data.length() - occurrence);
    }

    public String trimLeft(String data) {
        return this.trimLeft(data, ' ');
    }

    public String trimLeft(String data, char ch) {
        if (data == null) {
            return null;
        }
        int len = data.length();
        int occurrence = 0;
        for (int i = 0; i < len && data.charAt(i) == ch; ++i) {
            ++occurrence;
        }
        if (occurrence == 0) {
            return data;
        }
        return data.substring(occurrence, data.length());
    }

    public String toString(String[] array) {
        return this.toString(array, " ");
    }

    public String toString(String[] array, String sep) {
        if (array == null) {
            return null;
        }
        StringBuilder theData = new StringBuilder();
        for (int i = 0; i < array.length; ++i) {
            if (sep != null && i > 0) {
                theData.append(sep);
            }
            theData.append(array[i]);
        }
        return theData.toString();
    }

    public String toString(Object[] array) {
        return this.toString(array, ", ");
    }

    public String toString(Object[] array, String sep) {
        if (array == null) {
            return null;
        }
        StringBuilder theData = new StringBuilder();
        for (int i = 0; i < array.length; ++i) {
            if (sep != null && i > 0) {
                theData.append(sep);
            }
            if (array[i] != null) {
                theData.append(array[i]);
                continue;
            }
            theData.append("(null)");
        }
        return theData.toString();
    }

    public String toString(byte[] b) {
        if (b == null) {
            return "(null)";
        }
        return this.toString(b, 0, b.length);
    }

    public String toString(byte[] b, int ofs, int len) {
        if (b == null) {
            return "(null)";
        }
        StringBuilder sb = new StringBuilder(len * 3);
        for (int i = 0; i < len; ++i) {
            int c = b[ofs + i] & 0xFF;
            sb.append(hexDigits[c >> 4]);
            sb.append(hexDigits[c & 0xF]);
            if (i == len - 1) continue;
            sb.append(':');
        }
        return sb.toString();
    }

    public List<String> splitAsList(String splitString, int partLength) {
        if (splitString == null) {
            return null;
        }
        if (partLength <= 0 || splitString.length() <= partLength) {
            return List.of(splitString);
        }
        int len = splitString.length();
        int nparts = (len + partLength - 1) / partLength;
        ArrayList<String> result = new ArrayList<String>(nparts);
        int offset = 0;
        for (int i = 0; i < nparts; ++i) {
            result.add(splitString.substring(offset, Math.min(offset + partLength, len)));
            offset += partLength;
        }
        return result;
    }

    public List<String> splitAsList(String expression, String splitString) {
        if (expression == null) {
            return null;
        }
        ArrayList<String> result = new ArrayList<String>();
        if (splitString == null) {
            result.add(expression);
        } else if (splitString.length() == 0) {
            for (int i = 0; i < expression.length(); ++i) {
                result.add("" + expression.charAt(i));
            }
        } else {
            int start = 0;
            int splitLength = splitString.length();
            int i = expression.indexOf(splitString, start);
            if (i > 0) {
                while (i >= 0 && i <= expression.length()) {
                    i = expression.indexOf(splitString, start);
                    if (i <= 0) continue;
                    result.add(expression.substring(start, i));
                    start = i + splitLength;
                }
                if (start > 0 && start < expression.length()) {
                    result.add(expression.substring(start));
                }
            } else {
                result.add(expression);
            }
        }
        return result;
    }

    public String[] splitAsArray(String splitString, int partLength) {
        List<String> result = this.splitAsList(splitString, partLength);
        if (result == null) {
            return null;
        }
        String[] resultArr = new String[result.size()];
        resultArr = result.toArray(resultArr);
        return resultArr;
    }

    public String[] splitAsArray(String expression, String splitString) {
        List<String> result = this.splitAsList(expression, splitString);
        if (result == null) {
            return null;
        }
        String[] resultArr = new String[result.size()];
        resultArr = result.toArray(resultArr);
        return resultArr;
    }

    public String changeFirstLetterToUpperCase(String name) {
        if (name == null || name.length() == 0) {
            return name;
        }
        StringBuilder changedName = new StringBuilder();
        changedName.append(name.substring(0, 1).toUpperCase());
        changedName.append(name.substring(1, name.length()));
        return changedName.toString();
    }

    public String changeFirstLetterToLowerCase(String name) {
        if (name == null || name.length() == 0) {
            return name;
        }
        StringBuilder changedName = new StringBuilder();
        changedName.append(name.substring(0, 1).toLowerCase());
        changedName.append(name.substring(1, name.length()));
        return changedName.toString();
    }

    public String toCamelCase(String data, boolean startWithLowerCase) {
        if (data == null) {
            return null;
        }
        String d = data.trim();
        if (d.length() == 0) {
            return "";
        }
        StringBuilder result = new StringBuilder();
        StringBuilder buffer = new StringBuilder();
        int i = 0;
        while (buffer != null) {
            if (!this.appendString(buffer, d, i, CAMEL_CASE_STOP_CHARACTERS)) {
                if (buffer != null && buffer.length() > 0) {
                    String txt = buffer.toString();
                    buffer = new StringBuilder();
                    if (txt.toUpperCase().equals(txt)) {
                        txt = txt.toLowerCase();
                    }
                    if (result.length() == 0) {
                        if (startWithLowerCase) {
                            result.append(txt.toLowerCase());
                        } else {
                            result.append(this.changeFirstLetterToUpperCase(txt));
                        }
                    } else {
                        result.append(this.changeFirstLetterToUpperCase(txt));
                    }
                } else {
                    buffer = null;
                }
            }
            ++i;
        }
        return result.toString();
    }

    public String fromCamelCaseToSnakeCase(String data, boolean toLowerCase) {
        if (data == null) {
            return null;
        }
        String d = data.trim();
        if (d.length() == 0) {
            return "";
        }
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < d.length(); ++i) {
            char ch = d.charAt(i);
            if (Character.isSpaceChar(ch) || ch == '.') {
                result.append('_');
                continue;
            }
            if (i > 0 && Character.isLetter(ch) && ch == Character.toUpperCase(ch)) {
                result.append('_');
                if (toLowerCase) {
                    result.append(Character.toLowerCase(ch));
                    continue;
                }
                result.append(Character.toUpperCase(ch));
                continue;
            }
            if (ch == Character.toLowerCase(ch)) {
                if (toLowerCase) {
                    result.append(Character.toLowerCase(ch));
                    continue;
                }
                result.append(Character.toUpperCase(ch));
                continue;
            }
            if (toLowerCase) {
                result.append(Character.toLowerCase(ch));
                continue;
            }
            result.append(Character.toUpperCase(ch));
        }
        return result.toString();
    }

    public String toSnakeCase(String data) {
        if (data == null) {
            return null;
        }
        String d = data.trim();
        if (d.length() == 0) {
            return "";
        }
        StringBuilder result = new StringBuilder();
        StringBuilder buffer = new StringBuilder();
        int i = 0;
        while (buffer != null) {
            if (!this.appendString(buffer, d, i, CAMEL_CASE_STOP_CHARACTERS)) {
                if (buffer != null && buffer.length() > 0) {
                    String txt = buffer.toString();
                    buffer = new StringBuilder();
                    if (txt != null && txt.length() > 0) {
                        if (result.length() > 0) {
                            result.append('_');
                        }
                        result.append(txt);
                    }
                } else {
                    buffer = null;
                }
            }
            ++i;
        }
        return result.toString();
    }

    private boolean appendString(StringBuilder buffer, String input, int i, char[] characters) {
        if (input == null || input.length() == 0 || i < 0) {
            return false;
        }
        if (buffer != null && i < input.length()) {
            char ch = input.charAt(i);
            boolean existStopCharacter = false;
            for (int j = 0; j < characters.length; ++j) {
                if (ch != characters[j]) continue;
                existStopCharacter = true;
                break;
            }
            if (!existStopCharacter) {
                buffer.append(ch);
                return true;
            }
        }
        return false;
    }

    private static class HOLDER {
        static final StringUtil INSTANCE = new StringUtil();

        private HOLDER() {
        }
    }
}

