/*
 * Decompiled with CFR 0.152.
 */
package com.github.toolarium.jwebserver;

import com.github.toolarium.jwebserver.config.IWebServerConfiguration;
import com.github.toolarium.jwebserver.config.WebServerConfiguration;
import com.github.toolarium.jwebserver.handler.health.HealthHttpHandler;
import com.github.toolarium.jwebserver.handler.routing.RoutingHandler;
import com.github.toolarium.jwebserver.logger.LifecycleLogger;
import com.github.toolarium.jwebserver.logger.VerboseLevel;
import com.github.toolarium.jwebserver.logger.access.AccessLogHttpHandler;
import com.github.toolarium.jwebserver.logger.logback.LogbackUtil;
import com.github.toolarium.jwebserver.util.ConfigurationUtil;
import io.undertow.Handlers;
import io.undertow.Undertow;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import org.fusesource.jansi.AnsiConsole;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

@CommandLine.Command(name="jwebserver", mixinStandardHelpOptions=true, version={"jwebserver v1.2.6"}, description={"Small file server."})
public class JWebServer
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(JWebServer.class);
    @CommandLine.Option(names={"-b", "--bind"}, paramLabel="address", description={"The bind address, by default 0.0.0.0."})
    private String hostname;
    @CommandLine.Option(names={"-p", "--port"}, paramLabel="port", description={"The port, by default 8080."})
    private Integer port;
    @CommandLine.Option(names={"-s", "--securePort"}, paramLabel="securePort", description={"The secure port."})
    private Integer securePort;
    @CommandLine.Option(names={"--resourcePath"}, paramLabel="resourcePath", description={"The resource path, by default /."})
    private String resourcePath;
    @CommandLine.Option(names={"--healthPath"}, paramLabel="healthPath", defaultValue="/q/health", description={"The health path, by default /q/health."})
    private String healthPath;
    @CommandLine.Option(names={"--basicauth"}, paramLabel="authentication", description={"The basic authentication: user:password, by default disabled."})
    private String basicAuth;
    @CommandLine.Option(names={"--ioThreads"}, paramLabel="ioThreads", description={"The number of I/O threads."})
    private Integer ioThreads;
    @CommandLine.Option(names={"--workerThreads"}, paramLabel="workerThreads", description={"The number of worker threads."})
    private Integer workerThreads;
    @CommandLine.Option(names={"--name"}, paramLabel="webserverName", defaultValue="", description={"The webserver name."})
    private String webserverName;
    @CommandLine.Option(names={"--accessLogFormat"}, paramLabel="accessLogFormat", description={"Defines the access log format, default: combined."})
    private String accessLogFormatString;
    @CommandLine.Option(names={"--accessLogFilePattern"}, paramLabel="accessLogFilePattern", description={"Defines the access log file pattern, default: logs/access-%%d{yyyy-MM-dd}.log.gz."})
    private String accessLogFilePattern;
    @CommandLine.Option(names={"-d", "--directory"}, paramLabel="directory", description={"The directory, by default working path."})
    private String directory;
    @CommandLine.Option(names={"-l", "--listing"}, paramLabel="listing", description={"Enable directory listing."})
    private Boolean directoryListingEnabled;
    @CommandLine.Option(names={"--welcomeFiles"}, paramLabel="welcomeFiles", description={"The welcome files, by default index.html, index.htm."})
    private String welcomeFiles;
    @CommandLine.Option(names={"--disableResolveParentResourceIfNotFound"}, paramLabel="disableResolveParentResourceIfNotFound", description={"Disable the resolution of parent resources if the requested resource can' be found."})
    private Boolean disableResolveParentResourceIfNotFound;
    @CommandLine.Option(names={"--trustAll"}, paramLabel="trustAnyCertificate", description={"Define to trust any certificate, default false"})
    private Boolean trustAnyCertificate;
    @CommandLine.Option(names={"--proxy"}, paramLabel="proxyHost", description={"Defines the comma-separated url list in which this instance acts as a proxy."})
    private String proxyHostNameList;
    @CommandLine.Option(names={"--maxRequestTime"}, paramLabel="maxRequestTime", description={"Defines the max request time, default 30000"})
    private Integer maxRequestTime;
    @CommandLine.Option(names={"--connectionsPerThread"}, paramLabel="connectionsPerThread", description={"Defines the connections per thread, default 20."})
    private Integer connectionsPerThread;
    @CommandLine.Option(names={"--verbose"}, paramLabel="verboseLevel", defaultValue="INFO", description={"Specify the verbose level: (${COMPLETION-CANDIDATES}), by default INFO."})
    private VerboseLevel verboseLevel;
    @CommandLine.Option(names={"-v", "--version"}, versionHelp=true, description={"Display version info"})
    private boolean versionInfoRequested;
    @CommandLine.Option(names={"-h", "--help"}, usageHelp=true, description={"Display this help message"})
    private boolean usageHelpRequested;
    private WebServerConfiguration configuration = null;
    private LifecycleLogger lifecycleLogger = new LifecycleLogger();
    private transient Undertow server = null;
    private boolean hasError = false;

    public IWebServerConfiguration getConfiguration() {
        if (this.configuration == null) {
            if (this.port == null && this.securePort == null) {
                this.port = 8080;
            }
            WebServerConfiguration webServerConfiguration = new WebServerConfiguration().readProperties().setWebserverName(this.webserverName).setHostname(this.hostname).setPort(this.port).setSecurePort(this.securePort).setResourcePath(this.resourcePath).setBasicAuthentication(this.basicAuth).setHealthPath(this.healthPath).setIoThreads(this.ioThreads).setWorkerThreads(this.workerThreads).setVerboseLevel(this.verboseLevel).setAccessLogFilePattern(this.accessLogFilePattern).setAccessLogFormatString(this.accessLogFormatString);
            webServerConfiguration.getSSLServerConfiguration().setTrustAnyCertificate(this.trustAnyCertificate);
            Boolean resolveParentResourceIfNotFound = Boolean.TRUE;
            if (this.disableResolveParentResourceIfNotFound != null && this.disableResolveParentResourceIfNotFound.booleanValue()) {
                resolveParentResourceIfNotFound = Boolean.FALSE;
            }
            webServerConfiguration.getResourceServerConfiguration().setDirectory(this.directory).setDirectoryListingEnabled(this.directoryListingEnabled).setResolveParentResourceIfNotFound(resolveParentResourceIfNotFound).setWelcomeFiles(this.welcomeFiles);
            webServerConfiguration.getProxyServerConfiguration().setMaxRequestTime(this.maxRequestTime).setConnectionsPerThread(this.connectionsPerThread).setProxyHostNames(this.proxyHostNameList);
            this.setConfiguration(webServerConfiguration);
        }
        return this.configuration;
    }

    public void setConfiguration(IWebServerConfiguration webServerConfiguration) {
        this.configuration = new WebServerConfiguration(webServerConfiguration);
    }

    private CommandLine.Help.ColorScheme getColorSchmea() {
        return this.lifecycleLogger.getColorScheme();
    }

    public static void main(String[] args) {
        AnsiConsole.systemInstall();
        JWebServer jwebServer = new JWebServer();
        CommandLine commandLine = new CommandLine(jwebServer).setColorScheme(jwebServer.getColorSchmea()).registerConverter(String.class, s -> ConfigurationUtil.getInstance().expand(s)).registerConverter(Integer.class, s -> ConfigurationUtil.getInstance().convert(null, s, (Integer)null)).registerConverter(Boolean.class, s -> ConfigurationUtil.getInstance().convert(null, s, (Boolean)null)).registerConverter(VerboseLevel.class, s -> ConfigurationUtil.getInstance().convert(null, s, (VerboseLevel)null));
        int exitCode = commandLine.execute(args);
        if (jwebServer.hasError()) {
            LOG.debug("Executed Ended with code:" + exitCode);
        } else {
            LOG.debug("Successful started.");
        }
        AnsiConsole.systemUninstall();
    }

    public synchronized void start() {
        if (!this.isRunning()) {
            this.run();
        } else {
            LOG.warn("Server is already running!");
        }
    }

    public synchronized void stop() {
        if (this.isRunning()) {
            this.server.stop();
            this.server = null;
        } else {
            LOG.warn("Server is already stopped.");
        }
    }

    public boolean isRunning() {
        return this.server != null;
    }

    public boolean hasError() {
        return this.hasError;
    }

    @Override
    public synchronized void run() {
        if (this.verboseLevel != null && VerboseLevel.VERBOSE.equals((Object)this.verboseLevel)) {
            LogbackUtil.getInstance().enableVerbose();
        }
        IWebServerConfiguration webServerConfiguration = this.getConfiguration();
        try {
            LOG.info("Start server [" + webServerConfiguration.getHostname() + "] on port [" + webServerConfiguration.getPort() + "]...");
            io.undertow.server.RoutingHandler routingHandler = Handlers.routing();
            HealthHttpHandler.addHandler(webServerConfiguration, routingHandler);
            RoutingHandler.addHandler(webServerConfiguration, routingHandler);
            Undertow.Builder builder = Undertow.builder().setIoThreads(webServerConfiguration.getIoThreads()).setWorkerThreads(webServerConfiguration.getWorkerThreads());
            if (webServerConfiguration.getPort() != null) {
                builder.addHttpListener(webServerConfiguration.getPort(), webServerConfiguration.getHostname(), AccessLogHttpHandler.addHandler(webServerConfiguration, routingHandler));
            }
            if (webServerConfiguration.getSecurePort() != null) {
                try {
                    SSLContext sslContext = webServerConfiguration.getSSLServerConfiguration().getSSLContext();
                    HttpsURLConnection.setDefaultSSLSocketFactory(sslContext.getSocketFactory());
                    builder.addHttpsListener((int)webServerConfiguration.getSecurePort(), webServerConfiguration.getHostname(), sslContext, AccessLogHttpHandler.addHandler(webServerConfiguration, routingHandler));
                }
                catch (Exception e) {
                    if (!VerboseLevel.NONE.equals((Object)this.verboseLevel)) {
                        this.lifecycleLogger.printServerStartup(webServerConfiguration, null);
                    }
                    LOG.warn("Could not get SSL context [" + webServerConfiguration.getHostname() + "] on port [" + webServerConfiguration.getSecurePort() + "]\n" + this.lifecycleLogger.preapreThrowable(e));
                }
            }
            this.server = builder.build();
            this.server.start();
            if (!VerboseLevel.NONE.equals((Object)this.verboseLevel)) {
                this.lifecycleLogger.printServerStartup(webServerConfiguration, this.server.getListenerInfo());
            }
        }
        catch (RuntimeException ex) {
            this.hasError = true;
            if (!VerboseLevel.NONE.equals((Object)this.verboseLevel)) {
                this.lifecycleLogger.printServerStartup(webServerConfiguration, null);
            }
            int port = webServerConfiguration.getPort() != null ? webServerConfiguration.getPort().intValue() : webServerConfiguration.getSecurePort().intValue();
            LOG.warn("Could not start server [" + webServerConfiguration.getHostname() + "] on port [" + port + "]\n" + this.lifecycleLogger.preapreThrowable(ex));
        }
    }
}

