/*
 * Decompiled with CFR 0.152.
 */
package com.github.toolarium.jwebserver.config;

import com.github.toolarium.jwebserver.config.IProxyServerConfiguration;
import com.github.toolarium.jwebserver.util.ConfigurationUtil;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProxyServerConfiguration
implements IProxyServerConfiguration,
Serializable {
    private static final String END_VALUE = "].";
    private static final Logger LOG = LoggerFactory.getLogger(ProxyServerConfiguration.class);
    private static final long serialVersionUID = -6364554233103894914L;
    private boolean rewriteHostHeader;
    private boolean reuseXForwarded;
    private int maxRequestTime;
    private int connectionsPerThread;
    private String[] proxyHostNameList;

    public ProxyServerConfiguration() {
        this.rewriteHostHeader = true;
        this.reuseXForwarded = true;
        this.maxRequestTime = 30000;
        this.connectionsPerThread = 20;
        this.proxyHostNameList = null;
    }

    public ProxyServerConfiguration(IProxyServerConfiguration proxyServerConfiguration) {
        this.rewriteHostHeader = proxyServerConfiguration.rewriteHostHeader();
        this.reuseXForwarded = proxyServerConfiguration.reuseXForwarded();
        this.maxRequestTime = proxyServerConfiguration.getMaxRequestTime();
        this.connectionsPerThread = proxyServerConfiguration.getConnectionsPerThread();
        this.proxyHostNameList = proxyServerConfiguration.getProxyHostNames();
    }

    @Override
    public boolean rewriteHostHeader() {
        return this.rewriteHostHeader;
    }

    public ProxyServerConfiguration setRewriteHostHeader(Boolean rewriteHostHeader) {
        if (rewriteHostHeader != null) {
            LOG.debug("Set rewriteHostHeader: [" + rewriteHostHeader + END_VALUE);
            this.rewriteHostHeader = rewriteHostHeader;
        }
        return this;
    }

    @Override
    public boolean reuseXForwarded() {
        return this.reuseXForwarded;
    }

    public ProxyServerConfiguration setReuseXForwarded(Boolean reuseXForwarded) {
        if (reuseXForwarded != null) {
            LOG.debug("Set reuseXForwarded: [" + reuseXForwarded + END_VALUE);
            this.reuseXForwarded = reuseXForwarded;
        }
        return this;
    }

    @Override
    public int getMaxRequestTime() {
        return this.maxRequestTime;
    }

    public ProxyServerConfiguration setMaxRequestTime(Integer maxRequestTime) {
        if (maxRequestTime != null) {
            LOG.debug("Set maxRequestTime: [" + this.reuseXForwarded + END_VALUE);
            this.maxRequestTime = maxRequestTime;
        }
        return this;
    }

    @Override
    public int getConnectionsPerThread() {
        return this.connectionsPerThread;
    }

    public ProxyServerConfiguration setConnectionsPerThread(Integer connectionsPerThread) {
        if (connectionsPerThread != null) {
            LOG.debug("Set connectionsPerThread: [" + connectionsPerThread + END_VALUE);
            this.connectionsPerThread = connectionsPerThread;
        }
        return this;
    }

    @Override
    public String[] getProxyHostNames() {
        return this.proxyHostNameList;
    }

    public ProxyServerConfiguration setProxyHostNames(String proxyHostNameList) {
        if (proxyHostNameList != null) {
            this.setProxyHostNames(ConfigurationUtil.getInstance().parseStringArray(proxyHostNameList));
        }
        return this;
    }

    public ProxyServerConfiguration setProxyHostNames(String[] proxyHostNameList) {
        if (proxyHostNameList != null) {
            this.proxyHostNameList = proxyHostNameList;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Set proxyHostNameList: [" + ConfigurationUtil.getInstance().formatArrayAsString(this.proxyHostNameList) + END_VALUE);
            }
        }
        return this;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.proxyHostNameList);
        result = 31 * result + Objects.hash(this.connectionsPerThread, this.maxRequestTime, this.reuseXForwarded, this.rewriteHostHeader);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ProxyServerConfiguration other = (ProxyServerConfiguration)obj;
        return this.connectionsPerThread == other.connectionsPerThread && this.maxRequestTime == other.maxRequestTime && Arrays.equals(this.proxyHostNameList, other.proxyHostNameList) && this.reuseXForwarded == other.reuseXForwarded && this.rewriteHostHeader == other.rewriteHostHeader;
    }

    public String toString() {
        return "ProxyServerConfiguration [rewriteHostHeader=" + this.rewriteHostHeader + ", reuseXForwarded=" + this.reuseXForwarded + ", maxRequestTime=" + this.maxRequestTime + ", connectionsPerThread=" + this.connectionsPerThread + ", proxyHostNameList=" + Arrays.toString(this.proxyHostNameList) + "]";
    }
}

