/*
 * Decompiled with CFR 0.152.
 */
package com.github.toolarium.jwebserver.config;

import com.github.toolarium.jwebserver.config.IResourceServerConfiguration;
import com.github.toolarium.jwebserver.util.ConfigurationUtil;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceServerConfiguration
implements IResourceServerConfiguration,
Serializable {
    private static final long serialVersionUID = 2768362014487262782L;
    private static final String DOT = ".";
    private static final String END_VALUE = "].";
    private static final Logger LOG = LoggerFactory.getLogger(ResourceServerConfiguration.class);
    private static final String USER_HOME = System.getProperty("user.home");
    private String directory;
    private boolean isLocalDirectory;
    private boolean readFromClasspath;
    private boolean directoryListingEnabled;
    private boolean resolveParentResourceIfNotFound;
    private String[] welcomeFiles;
    private String[] supportedFileExtensions;

    public ResourceServerConfiguration() {
        this.directory = DOT;
        this.isLocalDirectory = true;
        this.readFromClasspath = false;
        this.directoryListingEnabled = false;
        this.resolveParentResourceIfNotFound = true;
        this.welcomeFiles = new String[]{"index.html", "index.htm", "default.html", "default.htm"};
        this.supportedFileExtensions = null;
    }

    public ResourceServerConfiguration(IResourceServerConfiguration configuration) {
        this.directory = configuration.getDirectory();
        this.isLocalDirectory = configuration.isLocalDirectory();
        this.readFromClasspath = configuration.readFromClasspath();
        this.directoryListingEnabled = configuration.isDirectoryListingEnabled();
        this.resolveParentResourceIfNotFound = configuration.resolveParentResourceIfNotFound();
        this.welcomeFiles = configuration.getWelcomeFiles();
        this.supportedFileExtensions = configuration.getSupportedFileExtensions();
    }

    @Override
    public String getDirectory() {
        return this.directory;
    }

    public ResourceServerConfiguration setDirectory(String directory) {
        if (directory != null) {
            LOG.debug("Assign property [directory] = [" + directory + "] from CLI.");
            this.setDirectory(directory, Boolean.FALSE);
        }
        return this;
    }

    public ResourceServerConfiguration setDirectory(String directory, Boolean readFromClasspath) {
        LOG.debug("Set directory: [" + directory + "], readFromClasspath: [" + readFromClasspath + END_VALUE);
        if (directory != null) {
            this.directory = directory.trim();
            if ("%HOME%".equals(directory) || "$HOME".equals(directory)) {
                this.directory = USER_HOME;
            }
        }
        if (readFromClasspath != null) {
            this.readFromClasspath = readFromClasspath;
        }
        LOG.debug("Set isLocalDirectory: " + this.directory.startsWith("/") + "/" + this.directory.startsWith("\\") + "/" + (this.directory.length() > 2 && this.directory.substring(1).startsWith(":")));
        this.isLocalDirectory = !this.readFromClasspath && !this.directory.startsWith("/") && !this.directory.startsWith("\\") && (this.directory.length() <= 2 || !this.directory.substring(1).startsWith(":"));
        return this;
    }

    @Override
    public boolean readFromClasspath() {
        return this.readFromClasspath;
    }

    @Override
    public boolean isLocalDirectory() {
        return this.isLocalDirectory;
    }

    @Override
    public boolean isDirectoryListingEnabled() {
        return this.directoryListingEnabled;
    }

    public ResourceServerConfiguration setDirectoryListingEnabled(Boolean directoryListingEnabled) {
        if (directoryListingEnabled != null) {
            LOG.debug("Set directoryListingEnabled: [" + directoryListingEnabled + END_VALUE);
            this.directoryListingEnabled = directoryListingEnabled;
        }
        return this;
    }

    @Override
    public boolean resolveParentResourceIfNotFound() {
        return this.resolveParentResourceIfNotFound;
    }

    public ResourceServerConfiguration setResolveParentResourceIfNotFound(Boolean resolveParentResourceIfNotFound) {
        if (resolveParentResourceIfNotFound != null) {
            LOG.debug("Set resolveParentResourceIfNotFound: [" + resolveParentResourceIfNotFound + END_VALUE);
            this.resolveParentResourceIfNotFound = resolveParentResourceIfNotFound;
        }
        return this;
    }

    @Override
    public String[] getWelcomeFiles() {
        return this.welcomeFiles;
    }

    public ResourceServerConfiguration setWelcomeFiles(String welcomeFiles) {
        if (welcomeFiles != null) {
            this.setWelcomeFiles(ConfigurationUtil.getInstance().parseStringArray(welcomeFiles));
        }
        return this;
    }

    public ResourceServerConfiguration setWelcomeFiles(String[] welcomeFiles) {
        if (welcomeFiles != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Set welcomeFiles: [" + ConfigurationUtil.getInstance().formatArrayAsString(welcomeFiles) + END_VALUE);
            }
            this.welcomeFiles = welcomeFiles;
        }
        return this;
    }

    @Override
    public String[] getSupportedFileExtensions() {
        return this.supportedFileExtensions;
    }

    public ResourceServerConfiguration setSupportedFileExtensions(String supportedFileExtensions) {
        if (supportedFileExtensions != null) {
            this.setSupportedFileExtensions(ConfigurationUtil.getInstance().parseStringArray(supportedFileExtensions));
        }
        return this;
    }

    public ResourceServerConfiguration setSupportedFileExtensions(String[] supportedFileExtensions) {
        if (supportedFileExtensions != null) {
            this.supportedFileExtensions = supportedFileExtensions;
            for (int i = 0; i < this.supportedFileExtensions.length; ++i) {
                if (this.supportedFileExtensions[i] == null || this.supportedFileExtensions[i].startsWith(DOT)) continue;
                this.supportedFileExtensions[i] = DOT + this.supportedFileExtensions[i];
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Set supportedFileExtensions: [" + ConfigurationUtil.getInstance().formatArrayAsString(this.supportedFileExtensions) + END_VALUE);
            }
        }
        return this;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.supportedFileExtensions);
        result = 31 * result + Arrays.hashCode(this.welcomeFiles);
        result = 31 * result + Objects.hash(this.directory, this.directoryListingEnabled, this.resolveParentResourceIfNotFound, this.isLocalDirectory, this.readFromClasspath);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ResourceServerConfiguration other = (ResourceServerConfiguration)obj;
        return Objects.equals(this.directory, other.directory) && this.directoryListingEnabled == other.directoryListingEnabled && this.resolveParentResourceIfNotFound == other.resolveParentResourceIfNotFound && this.isLocalDirectory == other.isLocalDirectory && this.readFromClasspath == other.readFromClasspath && Arrays.equals(this.supportedFileExtensions, other.supportedFileExtensions) && Arrays.equals(this.welcomeFiles, other.welcomeFiles);
    }

    public String toString() {
        return "ResourceServerConfiguration [directory=" + this.directory + ", isLocalDirectory=" + this.isLocalDirectory + ", readFromClasspath=" + this.readFromClasspath + ", directoryListingEnabled=" + this.directoryListingEnabled + ", resolveParentResourceIfNotFound=" + this.resolveParentResourceIfNotFound + ", welcomeFiles=" + Arrays.toString(this.welcomeFiles) + ", supportedFileExtensions=" + Arrays.toString(this.supportedFileExtensions) + "]";
    }
}

