/*
 * Decompiled with CFR 0.152.
 */
package com.github.toolarium.jwebserver.config;

import com.github.toolarium.common.security.ISecuredValue;
import com.github.toolarium.jwebserver.config.ISSLServerConfiguration;
import com.github.toolarium.jwebserver.util.CertificateUtil;
import com.github.toolarium.security.keystore.ISecurityManagerProvider;
import java.io.IOException;
import java.io.Serializable;
import java.security.GeneralSecurityException;
import java.util.Objects;
import javax.net.ssl.SSLContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SSLServerConfiguration
implements ISSLServerConfiguration,
Serializable {
    private static final String END_VALUE = "].";
    private static final Logger LOG = LoggerFactory.getLogger(SSLServerConfiguration.class);
    private static final long serialVersionUID = -566842518507270602L;
    private Boolean trustAnyCertificate = false;
    private String trustKeyStoreFile = null;
    private String keyStoreFile = null;
    private String keyStoreAlias = null;
    private ISecuredValue<String> keyStorePassword = null;
    private String keysStoreType = "PKCS12";
    private ISecurityManagerProvider securityManagerProvider = null;
    private SSLContext sslContext = null;

    @Override
    public Boolean trustAnyCertificate() {
        return this.trustAnyCertificate;
    }

    public SSLServerConfiguration setTrustAnyCertificate(Boolean trustAnyCertificate) {
        if (trustAnyCertificate != null) {
            LOG.debug("Set trustAnyCertificate: [" + trustAnyCertificate + END_VALUE);
            this.trustAnyCertificate = trustAnyCertificate;
        }
        return this;
    }

    @Override
    public String getTrustKeyStoreFile() {
        return this.trustKeyStoreFile;
    }

    public SSLServerConfiguration setTrustKeyStoreFile(String trustKeyStoreFile) {
        if (trustKeyStoreFile != null) {
            LOG.debug("Set trustKeyStoreFile: [" + trustKeyStoreFile + END_VALUE);
            this.trustKeyStoreFile = trustKeyStoreFile;
        }
        return this;
    }

    @Override
    public String getKeyStoreFile() {
        return this.keyStoreFile;
    }

    public SSLServerConfiguration setKeyStoreFile(String keyStoreFile) {
        if (keyStoreFile != null) {
            LOG.debug("Set keyStoreFile: [" + keyStoreFile + END_VALUE);
            this.keyStoreFile = keyStoreFile;
        }
        return this;
    }

    @Override
    public String getKeyStoreAlias() {
        return this.keyStoreAlias;
    }

    public SSLServerConfiguration setKeyStoreAlias(String keyStoreAlias) {
        if (keyStoreAlias != null) {
            LOG.debug("Set keyStoreAlias: [" + keyStoreAlias + END_VALUE);
            this.keyStoreAlias = keyStoreAlias;
        }
        return this;
    }

    @Override
    public ISecuredValue<String> getKeyStorePassword() {
        return this.keyStorePassword;
    }

    public SSLServerConfiguration setKeyStorePassword(ISecuredValue<String> keyStorePassword) {
        if (keyStorePassword != null) {
            LOG.debug("Set keyStorePassword: [" + String.valueOf(keyStorePassword) + END_VALUE);
            this.keyStorePassword = keyStorePassword;
        }
        return this;
    }

    @Override
    public String getKeyStoreType() {
        return this.keysStoreType;
    }

    public SSLServerConfiguration setKeyStoreType(String keysStoreType) {
        if (keysStoreType != null) {
            LOG.debug("Set keysStoreType: [" + keysStoreType + END_VALUE);
            this.keysStoreType = keysStoreType;
        }
        return this;
    }

    @Override
    public SSLContext getSSLContext() throws GeneralSecurityException, IOException {
        if (this.sslContext == null) {
            this.sslContext = CertificateUtil.getInstance().createSSLContext(this.getSecurityManagerProvider(), this.trustAnyCertificate() != null && this.trustAnyCertificate != false);
        }
        return this.sslContext;
    }

    public ISecurityManagerProvider getSecurityManagerProvider() throws GeneralSecurityException, IOException {
        if (this.securityManagerProvider == null) {
            this.securityManagerProvider = CertificateUtil.getInstance().getSecurityManagerProvider(this.getTrustKeyStoreFile(), this.getKeyStoreFile(), this.getKeyStoreType(), this.getKeyStoreAlias(), this.getKeyStorePassword());
        }
        return this.securityManagerProvider;
    }

    public int hashCode() {
        return Objects.hash(this.keyStoreAlias, this.keyStoreFile, this.keyStorePassword, this.keysStoreType, this.trustAnyCertificate, this.trustKeyStoreFile);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SSLServerConfiguration other = (SSLServerConfiguration)obj;
        return Objects.equals(this.keyStoreAlias, other.keyStoreAlias) && Objects.equals(this.keyStoreFile, other.keyStoreFile) && Objects.equals(this.keyStorePassword, other.keyStorePassword) && Objects.equals(this.keysStoreType, other.keysStoreType) && Objects.equals(this.trustAnyCertificate, other.trustAnyCertificate) && Objects.equals(this.trustKeyStoreFile, other.trustKeyStoreFile);
    }

    public String toString() {
        return "SSLServerConfiguration [trustAnyCertificate=" + this.trustAnyCertificate + ", trustKeyStoreFile=" + this.trustKeyStoreFile + ", keyStoreFile=" + this.keyStoreFile + ", keyStoreAlias=" + this.keyStoreAlias + ", keyStorePassword=" + String.valueOf(this.keyStorePassword) + ", keysStoreType=" + this.keysStoreType + "]";
    }
}

