/*
 * Decompiled with CFR 0.152.
 */
package com.github.toolarium.jwebserver.config;

import com.github.toolarium.common.security.ISecuredValue;
import com.github.toolarium.jwebserver.config.IWebServerConfiguration;
import com.github.toolarium.jwebserver.config.ProxyServerConfiguration;
import com.github.toolarium.jwebserver.config.ResourceServerConfiguration;
import com.github.toolarium.jwebserver.config.SSLServerConfiguration;
import com.github.toolarium.jwebserver.logger.VerboseLevel;
import com.github.toolarium.jwebserver.util.ConfigurationUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebServerConfiguration
implements IWebServerConfiguration {
    private static final String END_VALUE = "].";
    private static final String JWEBSERVER_PROPERTIES = "jwebserver.properties";
    private static final Logger LOG = LoggerFactory.getLogger(WebServerConfiguration.class);
    private String webserverName;
    private String hostname;
    private Integer port;
    private Integer securePort;
    private VerboseLevel verboseLevel;
    private String accessLogFormatString;
    private String accessLogFilePattern;
    private String basicAuthentication;
    private String healthPath;
    private int ioThreads;
    private int workerThreads;
    private String resourcePath;
    private SSLServerConfiguration sslServerConfiguration;
    private ResourceServerConfiguration resourceServerConfiguration;
    private ProxyServerConfiguration proxyServerConfiguration;

    public WebServerConfiguration() {
        this.webserverName = "";
        this.hostname = "0.0.0.0";
        this.port = null;
        this.securePort = null;
        this.verboseLevel = VerboseLevel.VERBOSE;
        this.accessLogFormatString = "combined";
        this.accessLogFilePattern = "logs/access-%d{yyyy-MM-dd}.log.gz";
        this.basicAuthentication = null;
        this.healthPath = "/q/health";
        this.ioThreads = Math.max(Runtime.getRuntime().availableProcessors(), 2);
        this.workerThreads = this.ioThreads * 8;
        this.resourcePath = "/";
        this.sslServerConfiguration = new SSLServerConfiguration();
        this.resourceServerConfiguration = new ResourceServerConfiguration();
        this.proxyServerConfiguration = new ProxyServerConfiguration();
    }

    public WebServerConfiguration(IWebServerConfiguration webServerConfiguration) {
        this.webserverName = webServerConfiguration.getWebserverName();
        this.hostname = webServerConfiguration.getHostname();
        this.port = webServerConfiguration.getPort();
        this.securePort = webServerConfiguration.getSecurePort();
        this.verboseLevel = webServerConfiguration.getVerboseLevel();
        this.accessLogFormatString = webServerConfiguration.getAccessLogFormatString();
        this.accessLogFilePattern = webServerConfiguration.getAccessLogFilePattern();
        this.basicAuthentication = webServerConfiguration.getBasicAuthentication();
        this.healthPath = webServerConfiguration.getHealthPath();
        this.ioThreads = webServerConfiguration.getIoThreads();
        this.workerThreads = webServerConfiguration.getWorkerThreads();
        this.resourcePath = webServerConfiguration.getResourcePath();
        this.sslServerConfiguration = webServerConfiguration.getSSLServerConfiguration();
        this.resourceServerConfiguration = new ResourceServerConfiguration(webServerConfiguration.getResourceServerConfiguration());
        this.proxyServerConfiguration = new ProxyServerConfiguration(webServerConfiguration.getProxyServerConfiguration());
    }

    @Override
    public String getWebserverName() {
        return this.webserverName;
    }

    public WebServerConfiguration setWebserverName(String webserverName) {
        if (webserverName != null && !webserverName.isBlank()) {
            LOG.debug("Set webserver name: [" + webserverName + "].  ");
            this.webserverName = webserverName.trim();
        }
        return this;
    }

    @Override
    public String getHostname() {
        return this.hostname;
    }

    public WebServerConfiguration setHostname(String hostname) {
        if (hostname != null && !hostname.isBlank()) {
            LOG.debug("Set hostname: [" + hostname + "].  ");
            this.hostname = hostname.trim();
        }
        return this;
    }

    @Override
    public Integer getPort() {
        return this.port;
    }

    public WebServerConfiguration setPort(Integer port) {
        if (port != null) {
            LOG.debug("Set port: [" + port + "].  ");
            this.port = port;
        }
        return this;
    }

    @Override
    public Integer getSecurePort() {
        return this.securePort;
    }

    public WebServerConfiguration setSecurePort(Integer securePort) {
        if (securePort != null) {
            LOG.debug("Set secure port: [" + securePort + "].  ");
            this.securePort = securePort;
        }
        return this;
    }

    @Override
    public VerboseLevel getVerboseLevel() {
        return this.verboseLevel;
    }

    public WebServerConfiguration setVerboseLevel(VerboseLevel verboseLevel) {
        if (verboseLevel != null) {
            LOG.debug("Set verboseLevel: [" + String.valueOf((Object)verboseLevel) + END_VALUE);
            this.verboseLevel = verboseLevel;
        }
        return this;
    }

    @Override
    public String getAccessLogFormatString() {
        return this.accessLogFormatString;
    }

    public WebServerConfiguration setAccessLogFormatString(String accessLogFormatString) {
        if (accessLogFormatString != null && !accessLogFormatString.isBlank()) {
            LOG.debug("Set accessLogFormatString: [" + accessLogFormatString + END_VALUE);
            this.accessLogFormatString = accessLogFormatString;
        }
        return this;
    }

    @Override
    public String getAccessLogFilePattern() {
        return this.accessLogFilePattern;
    }

    public WebServerConfiguration setAccessLogFilePattern(String accessLogFilePattern) {
        if (accessLogFilePattern != null && !accessLogFilePattern.isBlank()) {
            LOG.debug("Set accessLogFilePattern: [" + accessLogFilePattern + END_VALUE);
            this.accessLogFilePattern = accessLogFilePattern;
        }
        return this;
    }

    @Override
    public boolean hasBasicAuthentication() {
        return this.basicAuthentication != null && !this.basicAuthentication.isBlank();
    }

    @Override
    public String getBasicAuthentication() {
        return this.basicAuthentication;
    }

    public WebServerConfiguration setBasicAuthentication(String basicAuthentication) {
        if (basicAuthentication == null || basicAuthentication.isBlank()) {
            LOG.debug("Disable basicAuthentication.");
        } else {
            LOG.debug("Enable basicAuthentication.");
        }
        this.basicAuthentication = basicAuthentication;
        return this;
    }

    @Override
    public boolean hasHealthCheck() {
        return this.healthPath != null && !this.healthPath.isBlank();
    }

    @Override
    public String getHealthPath() {
        return this.healthPath;
    }

    public WebServerConfiguration setHealthPath(String healthPath) {
        if (healthPath == null || healthPath.isBlank()) {
            LOG.debug("Disable health check.");
        } else {
            LOG.debug("Enable health check: [" + healthPath + END_VALUE);
        }
        this.healthPath = healthPath;
        return this;
    }

    @Override
    public int getIoThreads() {
        return this.ioThreads;
    }

    public WebServerConfiguration setIoThreads(Integer ioThreads) {
        if (ioThreads != null && ioThreads > 0) {
            LOG.debug("Set ioThreads: [" + ioThreads + END_VALUE);
            this.ioThreads = ioThreads;
            this.setWorkerThreads(ioThreads * 8);
        }
        return this;
    }

    @Override
    public int getWorkerThreads() {
        return this.workerThreads;
    }

    public WebServerConfiguration setWorkerThreads(Integer workerThreads) {
        if (workerThreads != null && workerThreads > 0) {
            LOG.debug("Set workerThreads: [" + workerThreads + END_VALUE);
            this.workerThreads = workerThreads;
        }
        return this;
    }

    @Override
    public String getResourcePath() {
        return this.resourcePath;
    }

    public WebServerConfiguration setResourcePath(String resourcePath) {
        if (resourcePath != null && !resourcePath.isBlank()) {
            LOG.debug("Set resourcePath: [" + resourcePath + END_VALUE);
            this.resourcePath = resourcePath;
            if (resourcePath.endsWith("/")) {
                this.resourcePath = resourcePath.substring(0, resourcePath.length() - 1);
            }
        }
        return this;
    }

    @Override
    public SSLServerConfiguration getSSLServerConfiguration() {
        return this.sslServerConfiguration;
    }

    @Override
    public ResourceServerConfiguration getResourceServerConfiguration() {
        return this.resourceServerConfiguration;
    }

    @Override
    public ProxyServerConfiguration getProxyServerConfiguration() {
        return this.proxyServerConfiguration;
    }

    @Override
    public boolean isProxyServer() {
        return this.proxyServerConfiguration != null && this.proxyServerConfiguration.getProxyHostNames() != null && this.proxyServerConfiguration.getProxyHostNames().length > 0 && !this.proxyServerConfiguration.getProxyHostNames()[0].isBlank();
    }

    public WebServerConfiguration readProperties() {
        Properties properties = this.readPropertiesFromClasspath();
        if (properties == null) {
            return this;
        }
        this.setWebserverName(this.readProperty(properties, "webserverName", this.webserverName, false));
        this.setHostname(this.readProperty(properties, "hostname", this.hostname, false));
        this.setPort(this.readProperty(properties, "port", this.port, true));
        this.setSecurePort(this.readProperty(properties, "securePort", this.securePort, true));
        this.setIoThreads(this.readProperty(properties, "ioThreads", this.ioThreads, false));
        this.setWorkerThreads(this.readProperty(properties, "workerThreads", this.workerThreads, false));
        this.setVerboseLevel(this.readProperty(properties, "verboseLevel", this.verboseLevel, false));
        this.setAccessLogFormatString(this.readProperty(properties, "accessLogFormatString", this.accessLogFormatString, false));
        this.setAccessLogFilePattern(this.readProperty(properties, "accessLogFilePattern", this.accessLogFilePattern, false));
        this.setBasicAuthentication(this.readProperty(properties, "basicAuthentication", this.basicAuthentication, true));
        this.setHealthPath(this.readProperty(properties, "healthPath", this.healthPath, true));
        this.setResourcePath(this.readProperty(properties, "resourcePath", this.getResourcePath(), false));
        this.sslServerConfiguration.setTrustAnyCertificate(this.readProperty(properties, "trustAnyCertificate", this.sslServerConfiguration.trustAnyCertificate(), true));
        this.sslServerConfiguration.setTrustKeyStoreFile(this.readProperty(properties, "trustKeyStoreFile", this.sslServerConfiguration.getTrustKeyStoreFile(), true));
        this.sslServerConfiguration.setKeyStoreFile(this.readProperty(properties, "keyStoreFile", this.sslServerConfiguration.getKeyStoreFile(), true));
        this.sslServerConfiguration.setKeyStoreAlias(this.readProperty(properties, "keyStoreAlias", this.sslServerConfiguration.getKeyStoreAlias(), true));
        this.sslServerConfiguration.setKeyStorePassword(this.readProperty(properties, "keyStorePassword", this.sslServerConfiguration.getKeyStorePassword(), true));
        this.sslServerConfiguration.setKeyStoreType(this.readProperty(properties, "keysStoreType", this.sslServerConfiguration.getKeyStoreType(), true));
        this.resourceServerConfiguration.setDirectory(this.readProperty(properties, "directory", this.resourceServerConfiguration.getDirectory(), false), this.readProperty(properties, "readFromClasspath", this.resourceServerConfiguration.readFromClasspath(), false));
        if (!this.resourceServerConfiguration.readFromClasspath()) {
            this.resourceServerConfiguration.setDirectoryListingEnabled(this.readProperty(properties, "directoryListingEnabled", this.resourceServerConfiguration.isDirectoryListingEnabled(), false));
        } else {
            this.resourceServerConfiguration.setDirectoryListingEnabled(Boolean.FALSE);
        }
        this.resourceServerConfiguration.setResolveParentResourceIfNotFound(this.readProperty(properties, "resolveParentResourceIfNotFound", this.resourceServerConfiguration.resolveParentResourceIfNotFound(), false));
        this.resourceServerConfiguration.setWelcomeFiles(this.readProperty(properties, "welcomeFiles", ConfigurationUtil.getInstance().formatArrayAsString(this.resourceServerConfiguration.getWelcomeFiles()), false));
        this.resourceServerConfiguration.setSupportedFileExtensions(this.readProperty(properties, "supportedFileExtensions", ConfigurationUtil.getInstance().formatArrayAsString(this.resourceServerConfiguration.getSupportedFileExtensions()), false));
        this.proxyServerConfiguration.setRewriteHostHeader(this.readProperty(properties, "rewriteHostHeader", this.proxyServerConfiguration.rewriteHostHeader(), true));
        this.proxyServerConfiguration.setReuseXForwarded(this.readProperty(properties, "reuseXForwarded", this.proxyServerConfiguration.reuseXForwarded(), true));
        this.proxyServerConfiguration.setMaxRequestTime(this.readProperty(properties, "maxRequestTime", this.proxyServerConfiguration.getMaxRequestTime(), true));
        this.proxyServerConfiguration.setConnectionsPerThread(this.readProperty(properties, "connectionsPerThread", this.proxyServerConfiguration.getConnectionsPerThread(), true));
        this.proxyServerConfiguration.setProxyHostNames(this.readProperty(properties, "proxy", ConfigurationUtil.getInstance().formatArrayAsString(this.proxyServerConfiguration.getProxyHostNames()), true));
        return this;
    }

    public String toString() {
        return "WebServerConfiguration [webserverName=" + this.webserverName + ", hostname=" + this.hostname + ", port=" + this.port + ", securePort=" + this.securePort + ", verboseLevel=" + String.valueOf((Object)this.verboseLevel) + ", accessLogFormatString=" + this.accessLogFormatString + ", accessLogFilePattern=" + this.accessLogFilePattern + ", basicAuthentication=" + this.basicAuthentication + ", healthPath=" + this.healthPath + ", ioThreads=" + this.ioThreads + ", workerThreads=" + this.workerThreads + ", resourcePath=" + this.resourcePath + ", resourceServerConfiguration=" + String.valueOf(this.resourceServerConfiguration) + ", proxyServerConfiguration=" + String.valueOf(this.proxyServerConfiguration) + "]";
    }

    private Properties readPropertiesFromClasspath() {
        Properties properties = null;
        try (InputStream stream = this.getClass().getResourceAsStream("/jwebserver.properties");){
            int countEntries = 0;
            if (stream != null) {
                String line;
                LOG.debug("Found jwebserver.properties...");
                properties = new Properties();
                InputStreamReader inputStreamReader = new InputStreamReader(stream);
                BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
                while ((line = bufferedReader.readLine()) != null) {
                    String c;
                    int idx;
                    if (line.isBlank() || line.trim().startsWith("#") || (idx = (c = line.trim()).indexOf(61)) <= 0) continue;
                    String key = c.substring(0, idx).trim();
                    String value = c.substring(idx + 1).trim();
                    properties.setProperty(key, value);
                    ++countEntries;
                }
            }
            if (countEntries == 0) {
                properties = null;
            }
        }
        catch (IOException ex) {
            LOG.info("Could not read and parse confuguration jwebserver.properties from classpath.");
        }
        return properties;
    }

    private String readProperty(Properties properties, String name, String defaultValue, boolean allowEmptyValue) {
        String result = ConfigurationUtil.getInstance().expand(properties.getProperty(name, defaultValue));
        if (result == null || result.isBlank()) {
            if (allowEmptyValue) {
                LOG.debug("Assign property [" + name + "] = [" + result + "] from jwebserver.properties.");
                return result;
            }
            LOG.debug("Assign default property [" + name + "] = [" + defaultValue + "] from jwebserver.properties.");
            return defaultValue;
        }
        if (!result.equals(defaultValue)) {
            LOG.debug("Assign property [" + name + "] = [" + result + "] from jwebserver.properties.");
        }
        return result;
    }

    private Boolean readProperty(Properties properties, String name, Boolean defaultValue, boolean allowEmptyValue) {
        String result = this.readProperty(properties, name, "" + defaultValue, allowEmptyValue);
        if (result == null || result.isBlank()) {
            if (allowEmptyValue) {
                return null;
            }
            return defaultValue;
        }
        return ConfigurationUtil.getInstance().convert(name, result, defaultValue);
    }

    private Integer readProperty(Properties properties, String name, Integer defaultValue, boolean allowEmptyValue) {
        String result = this.readProperty(properties, name, "" + defaultValue, allowEmptyValue);
        if (result == null || result.isBlank()) {
            if (allowEmptyValue) {
                return null;
            }
            return defaultValue;
        }
        return ConfigurationUtil.getInstance().convert(name, result, defaultValue);
    }

    private VerboseLevel readProperty(Properties properties, String name, VerboseLevel defaultValue, boolean allowEmptyValue) {
        String result = this.readProperty(properties, name, String.valueOf((Object)defaultValue), allowEmptyValue);
        if (result == null || result.isBlank()) {
            if (allowEmptyValue) {
                return null;
            }
            return defaultValue;
        }
        return ConfigurationUtil.getInstance().convert(name, result, defaultValue);
    }

    private ISecuredValue<String> readProperty(Properties properties, String name, ISecuredValue<String> defaultValue, boolean allowEmptyValue) {
        String result = this.readProperty(properties, name, String.valueOf(defaultValue), allowEmptyValue);
        if (result == null || result.isBlank()) {
            if (allowEmptyValue) {
                return null;
            }
            return defaultValue;
        }
        return ConfigurationUtil.getInstance().convert(name, result, defaultValue);
    }
}

