/*
 * Decompiled with CFR 0.152.
 */
package com.github.toolarium.jwebserver.handler.auth;

import com.github.toolarium.jwebserver.config.IWebServerConfiguration;
import com.github.toolarium.jwebserver.handler.auth.MemoryIdentityManager;
import io.undertow.security.api.AuthenticationMechanism;
import io.undertow.security.api.AuthenticationMode;
import io.undertow.security.handlers.AuthenticationCallHandler;
import io.undertow.security.handlers.AuthenticationConstraintHandler;
import io.undertow.security.handlers.AuthenticationMechanismsHandler;
import io.undertow.security.handlers.SecurityInitialHandler;
import io.undertow.security.idm.IdentityManager;
import io.undertow.security.impl.BasicAuthenticationMechanism;
import io.undertow.server.HttpHandler;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

public final class BasicAuthenticationHttpHandler {
    private BasicAuthenticationHttpHandler() {
    }

    public static HttpHandler addHandler(IWebServerConfiguration webServerConfiguration, HttpHandler handlerToWrap) {
        int idx;
        HashMap<String, char[]> users = new HashMap<String, char[]>(1);
        String basicAuth = webServerConfiguration.getBasicAuthentication();
        if (webServerConfiguration.hasBasicAuthentication() && basicAuth != null && !basicAuth.isBlank() && (idx = basicAuth.indexOf(58)) > 0) {
            users.put(basicAuth.substring(0, idx).trim(), basicAuth.substring(idx + 1).trim().toCharArray());
        }
        return BasicAuthenticationHttpHandler.addHandler(webServerConfiguration, handlerToWrap, "", new MemoryIdentityManager(users));
    }

    public static HttpHandler addHandler(IWebServerConfiguration webServerConfiguration, HttpHandler handlerToWrap, String realmName, IdentityManager identityManager) {
        HttpHandler handler = handlerToWrap;
        String basicAuth = webServerConfiguration.getBasicAuthentication();
        if (webServerConfiguration.hasBasicAuthentication() && basicAuth != null && !basicAuth.isBlank()) {
            handler = new AuthenticationCallHandler(handler);
            handler = new AuthenticationConstraintHandler(handler);
            List<AuthenticationMechanism> mechanisms = Collections.singletonList(new BasicAuthenticationMechanism(realmName));
            handler = new AuthenticationMechanismsHandler(handler, mechanisms);
            handler = new SecurityInitialHandler(AuthenticationMode.PRO_ACTIVE, identityManager, handler);
        }
        return handler;
    }
}

