/*
 * Decompiled with CFR 0.152.
 */
package com.github.toolarium.jwebserver.handler.auth;

import io.undertow.security.idm.Account;
import io.undertow.security.idm.Credential;
import io.undertow.security.idm.IdentityManager;
import io.undertow.security.idm.PasswordCredential;
import java.security.Principal;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Set;

public class MemoryIdentityManager
implements IdentityManager {
    private final Map<String, char[]> users;

    public MemoryIdentityManager(Map<String, char[]> users) {
        this.users = users;
    }

    @Override
    public Account verify(Account account) {
        return account;
    }

    @Override
    public Account verify(String id, Credential credential) {
        Account account = this.getAccount(id);
        if (account != null && this.verifyCredential(account, credential)) {
            return account;
        }
        return null;
    }

    @Override
    public Account verify(Credential credential) {
        return null;
    }

    private boolean verifyCredential(Account account, Credential credential) {
        if (credential instanceof PasswordCredential) {
            char[] password = ((PasswordCredential)credential).getPassword();
            char[] expectedPassword = this.users.get(account.getPrincipal().getName());
            return Arrays.equals(password, expectedPassword);
        }
        return false;
    }

    private Account getAccount(final String id) {
        if (this.users.containsKey(id)) {
            return new Account(){
                private static final long serialVersionUID = -2295318059471579884L;
                private final Principal principal = new Principal(){

                    @Override
                    public String getName() {
                        return id;
                    }
                };

                @Override
                public Principal getPrincipal() {
                    return this.principal;
                }

                @Override
                public Set<String> getRoles() {
                    return Collections.emptySet();
                }
            };
        }
        return null;
    }
}

