/*
 * Decompiled with CFR 0.152.
 */
package com.github.toolarium.jwebserver.handler.health;

import com.github.toolarium.jwebserver.config.IWebServerConfiguration;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.RoutingHandler;
import io.undertow.util.Headers;

public final class HealthHttpHandler
implements HttpHandler {
    @Override
    public void handleRequest(HttpServerExchange exchange) throws Exception {
        exchange.getResponseHeaders().put(Headers.CONTENT_TYPE, "application/json");
        exchange.getResponseSender().send("{ \"status\": \"UP\" }");
    }

    public static RoutingHandler addHandler(IWebServerConfiguration webServerConfiguration, RoutingHandler routingHandler) {
        if (webServerConfiguration.hasHealthCheck()) {
            routingHandler.get(webServerConfiguration.getHealthPath(), new HealthHttpHandler());
        }
        return routingHandler;
    }
}

