/*
 * Decompiled with CFR 0.152.
 */
package com.github.toolarium.jwebserver.handler.routing.proxy;

import com.github.toolarium.jwebserver.config.IWebServerConfiguration;
import com.github.toolarium.jwebserver.config.ProxyServerConfiguration;
import io.undertow.UndertowOptions;
import io.undertow.protocols.ssl.UndertowXnioSsl;
import io.undertow.server.handlers.proxy.LoadBalancingProxyClient;
import java.net.URI;
import java.net.URISyntaxException;
import javax.net.ssl.SSLContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnio.OptionMap;
import org.xnio.Xnio;

public final class ProxyHandler {
    private static final Logger LOG = LoggerFactory.getLogger(ProxyHandler.class);

    private ProxyHandler() {
    }

    public static io.undertow.server.handlers.proxy.ProxyHandler createProxyHandler(IWebServerConfiguration webServerConfiguration) {
        ProxyServerConfiguration configuration = webServerConfiguration.getProxyServerConfiguration();
        LoadBalancingProxyClient loadBalancer = new LoadBalancingProxyClient().setConnectionsPerThread(configuration.getConnectionsPerThread());
        String[] hostNames = configuration.getProxyHostNames();
        if (hostNames != null && hostNames.length > 0) {
            for (String hostName : hostNames) {
                if (hostName == null || hostName.isBlank()) continue;
                try {
                    URI uri = new URI(hostName);
                    SSLContext sslContext = null;
                    if (uri.getScheme() == null || uri.getScheme().isBlank()) {
                        LOG.warn("Could not found schema in uri [" + hostName + "]!");
                    } else if (uri.getScheme().endsWith("s")) {
                        try {
                            sslContext = webServerConfiguration.getSSLServerConfiguration().getSSLContext();
                        }
                        catch (Exception e) {
                            loadBalancer.addHost(uri);
                            LOG.warn("Could not initialize the SSL contect: " + e.getMessage(), e);
                        }
                    }
                    if (sslContext != null) {
                        loadBalancer.addHost(uri, null, new UndertowXnioSsl(Xnio.getInstance(), OptionMap.EMPTY, sslContext), OptionMap.create(UndertowOptions.ENABLE_HTTP2, true));
                        continue;
                    }
                    loadBalancer.addHost(uri);
                }
                catch (URISyntaxException e) {
                    LOG.warn("Could not parse uri: " + hostName);
                }
            }
        }
        return io.undertow.server.handlers.proxy.ProxyHandler.builder().setProxyClient(loadBalancer).setMaxRequestTime(configuration.getMaxRequestTime()).setReuseXForwarded(configuration.reuseXForwarded()).setRewriteHostHeader(configuration.rewriteHostHeader()).build();
    }
}

