/*
 * Decompiled with CFR 0.152.
 */
package com.github.toolarium.jwebserver.handler.routing.resource;

import com.github.toolarium.jwebserver.config.IResourceServerConfiguration;
import com.github.toolarium.jwebserver.config.IWebServerConfiguration;
import com.github.toolarium.jwebserver.util.ResourceUtil;
import io.undertow.server.handlers.resource.Resource;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PathResourceManager
extends io.undertow.server.handlers.resource.PathResourceManager {
    private static final Logger LOG = LoggerFactory.getLogger(PathResourceManager.class);
    private final IResourceServerConfiguration configuration;
    private List<String> welcomeFiles;

    public PathResourceManager(IWebServerConfiguration webServerConfiguration, Path base, long transferMinSize) {
        super(base, transferMinSize);
        this.configuration = webServerConfiguration.getResourceServerConfiguration();
        this.welcomeFiles = Collections.emptyList();
    }

    public void setWelcomeFiles(String[] welcomeFiles) {
        if (welcomeFiles != null) {
            this.welcomeFiles = Arrays.asList(welcomeFiles);
        }
    }

    @Override
    public Resource getResource(String path) {
        Resource resource = super.getResource(path);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Request resource [" + path + "]" + ResourceUtil.getInstance().toString(resource));
        }
        if (resource == null && path.indexOf(46) < 0 && this.configuration.getSupportedFileExtensions() != null && this.configuration.getSupportedFileExtensions().length > 0) {
            for (String supportedFileExtension : this.configuration.getSupportedFileExtensions()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Check resource [" + path + "] with extension [" + supportedFileExtension + "].");
                }
                if ((resource = super.getResource(path + supportedFileExtension)) == null) continue;
                if (!LOG.isDebugEnabled()) break;
                LOG.debug("Found resource [" + path + supportedFileExtension + "] in  [" + String.valueOf(resource.getUrl()) + "] " + resource.getContentLength());
                break;
            }
        }
        if (this.configuration.resolveParentResourceIfNotFound() && resource != null && resource.isDirectory() && !path.endsWith("/")) {
            String directoryPath = ResourceUtil.getInstance().slashify(path);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Test welcome files: " + String.valueOf(this.welcomeFiles));
            }
            Resource indexResource = null;
            String[] directorySplit = directoryPath.split("/");
            for (int i = directorySplit.length - 1; i >= 0; --i) {
                String parentPath = ResourceUtil.getInstance().prepareString(directorySplit, i);
                indexResource = this.getIndexFiles(parentPath);
                if (indexResource == null) continue;
                resource = indexResource;
                break;
            }
        }
        return resource;
    }

    protected Resource getIndexFiles(String base) {
        for (String possibility : this.welcomeFiles) {
            Resource indexResource;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Test resource [" + base + "] [" + ResourceUtil.getInstance().canonicalize(ResourceUtil.getInstance().slashify(base) + possibility) + "]");
            }
            if ((indexResource = super.getResource(ResourceUtil.getInstance().canonicalize(ResourceUtil.getInstance().slashify(base) + possibility))) == null) continue;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Request resource index found [" + base + "]" + ResourceUtil.getInstance().toString(indexResource));
            }
            return indexResource;
        }
        return null;
    }
}

