/*
 * Decompiled with CFR 0.152.
 */
package com.github.toolarium.jwebserver.handler.routing.resource;

import com.github.toolarium.jwebserver.config.IWebServerConfiguration;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.Headers;
import io.undertow.util.Methods;
import io.undertow.util.RedirectBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedirectDirectoryHandler
implements HttpHandler {
    private static final Logger LOG = LoggerFactory.getLogger(RedirectDirectoryHandler.class);
    private static final String HTTP2_UPGRADE_PREFIX = "h2";
    private final IWebServerConfiguration webServerConfiguration;
    private final HttpHandler next;

    public RedirectDirectoryHandler(IWebServerConfiguration webServerConfiguration, HttpHandler next) {
        this.webServerConfiguration = webServerConfiguration;
        this.next = next;
    }

    @Override
    public void handleRequest(HttpServerExchange exchange) throws Exception {
        boolean isUpgradeRequest;
        Object resourcePath = this.webServerConfiguration.getResourcePath();
        if (!((String)resourcePath).endsWith("/")) {
            resourcePath = (String)resourcePath + "/";
        }
        boolean redirect = !exchange.getRelativePath().startsWith((String)resourcePath);
        String upgradeString = exchange.getRequestHeaders().getFirst(Headers.UPGRADE);
        boolean bl = isUpgradeRequest = upgradeString != null && !upgradeString.startsWith(HTTP2_UPGRADE_PREFIX);
        if (redirect && !isUpgradeRequest) {
            if (exchange.getRequestMethod().equals(Methods.GET) || exchange.getRequestMethod().equals(Methods.HEAD)) {
                exchange.setStatusCode(302);
            } else {
                exchange.setStatusCode(307);
            }
            if (!exchange.getRelativePath().endsWith("/")) {
                resourcePath = exchange.getRelativePath() + "/";
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Directory redirect: " + exchange.getRelativePath() + " -> " + (String)resourcePath);
                }
                exchange.getResponseHeaders().put(Headers.LOCATION, RedirectBuilder.redirect(exchange, (String)resourcePath, true));
                return;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Redirect to sub url: " + exchange.getRelativePath() + " -> " + (String)resourcePath);
            }
        }
        this.next.handleRequest(exchange);
    }
}

