/*
 * Decompiled with CFR 0.152.
 */
package com.github.toolarium.jwebserver.handler.routing.resource;

import com.github.toolarium.jwebserver.config.IWebServerConfiguration;
import com.github.toolarium.jwebserver.config.ResourceServerConfiguration;
import com.github.toolarium.jwebserver.handler.routing.resource.ClassPathResourceManager;
import com.github.toolarium.jwebserver.handler.routing.resource.PathResourceManager;
import io.undertow.Handlers;
import java.nio.file.Paths;

public final class ResourceHandler {
    private ResourceHandler() {
    }

    public static io.undertow.server.handlers.resource.ResourceHandler createResourceHandler(IWebServerConfiguration webServerConfiguration) {
        io.undertow.server.handlers.resource.ResourceHandler resourceHandler;
        ResourceServerConfiguration configuration = webServerConfiguration.getResourceServerConfiguration();
        String path = configuration.getDirectory();
        if (webServerConfiguration.getResourceServerConfiguration().readFromClasspath()) {
            if (path == null) {
                path = "";
            }
            ClassPathResourceManager classResourceManager = new ClassPathResourceManager(webServerConfiguration, ResourceHandler.class.getClassLoader(), path);
            classResourceManager.setWelcomeFiles(configuration.getWelcomeFiles());
            resourceHandler = Handlers.resource(classResourceManager);
        } else {
            if (path == null) {
                path = ".";
            }
            PathResourceManager pathResourceManager = new PathResourceManager(webServerConfiguration, Paths.get(path, new String[0]), 10L);
            pathResourceManager.setWelcomeFiles(configuration.getWelcomeFiles());
            resourceHandler = Handlers.resource(pathResourceManager);
        }
        if (webServerConfiguration.getResourceServerConfiguration().getWelcomeFiles() != null) {
            resourceHandler.setWelcomeFiles(webServerConfiguration.getResourceServerConfiguration().getWelcomeFiles());
        }
        resourceHandler.setDirectoryListingEnabled(webServerConfiguration.getResourceServerConfiguration().isDirectoryListingEnabled());
        String resourcePath = webServerConfiguration.getResourcePath();
        if (resourcePath == null || resourcePath.isBlank()) {
            resourcePath = "/";
        }
        return resourceHandler;
    }
}

