/*
 * Decompiled with CFR 0.152.
 */
package com.github.toolarium.jwebserver.logger;

import com.github.toolarium.jwebserver.config.IResourceServerConfiguration;
import com.github.toolarium.jwebserver.config.IWebServerConfiguration;
import com.github.toolarium.jwebserver.logger.ansi.ColoredStackTraceWriter;
import com.github.toolarium.jwebserver.util.ConfigurationUtil;
import io.undertow.Undertow;
import java.io.PrintWriter;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.List;
import picocli.CommandLine;

public class LifecycleLogger {
    private static final String NL = "\n";
    private static final String LINE = "----------------------------------------------------------------------------------------";
    private static final String APP = "jwebserver v1.2.6";
    private CommandLine.Help.ColorScheme colorSchema = CommandLine.Help.defaultColorScheme(CommandLine.Help.Ansi.AUTO);

    public LifecycleLogger() {
    }

    public LifecycleLogger(CommandLine.Help.ColorScheme colorSchema) {
        this.colorSchema = colorSchema;
    }

    public CommandLine.Help.ColorScheme getColorScheme() {
        return this.colorSchema;
    }

    public void printServerStartup(IWebServerConfiguration webServerConfiguration, List<Undertow.ListenerInfo> listenerInfoList) {
        System.out.println(this.prepareServerStartup(webServerConfiguration, listenerInfoList));
    }

    public String preapreThrowable(Throwable t) {
        CommandLine.Help.ColorScheme colorScheme = new CommandLine.Help.ColorScheme.Builder(this.getColorScheme()).applySystemProperties().build();
        ColoredStackTraceWriter stringWriter = new ColoredStackTraceWriter(colorScheme);
        t.printStackTrace(new PrintWriter(stringWriter));
        return stringWriter.toString();
    }

    public String prepareServerStartup(IWebServerConfiguration webServerConfiguration, List<Undertow.ListenerInfo> listenerInfoList) {
        String resourcePath = this.prepareResourcePath(webServerConfiguration);
        StringBuilder message = new StringBuilder();
        message.append(NL).append(LINE).append(NL);
        this.preapreTitle(message, webServerConfiguration);
        this.prepareListener(message, webServerConfiguration, listenerInfoList, resourcePath);
        if (webServerConfiguration.isProxyServer()) {
            this.prepareProxy(message, webServerConfiguration, resourcePath);
        } else {
            this.prepareResource(message, webServerConfiguration, resourcePath);
        }
        if (listenerInfoList != null) {
            if (webServerConfiguration.hasHealthCheck()) {
                this.prepareHeader(message, "Health").append(this.commandText(webServerConfiguration.getHealthPath())).append(NL);
            }
            if (webServerConfiguration.hasBasicAuthentication()) {
                this.prepareHeader(message, "Basic Auth").append("enabled").append(NL);
            }
            if (!webServerConfiguration.isProxyServer() && webServerConfiguration.getResourceServerConfiguration().isDirectoryListingEnabled()) {
                this.prepareHeader(message, "Listing").append("enabled").append(NL);
            }
        }
        message.append(LINE).append(NL);
        return message.toString();
    }

    public String prepareResourcePath(IWebServerConfiguration webServerConfiguration) {
        Object resourcePath = webServerConfiguration.getResourcePath();
        if (!((String)resourcePath).isEmpty() && !((String)resourcePath).startsWith("/")) {
            resourcePath = "/" + (String)resourcePath;
        }
        if (!((String)resourcePath).endsWith("/")) {
            resourcePath = (String)resourcePath + "/";
        }
        return resourcePath;
    }

    private String preparePath(IResourceServerConfiguration resourceConfiguration, String resourcePath) {
        Object path = resourceConfiguration.getDirectory();
        if (((String)path).equals(".")) {
            path = "";
        }
        if (!((String)path).isEmpty() && !((String)path).startsWith("/")) {
            path = "/" + (String)path;
        }
        if (!resourcePath.equals("/")) {
            path = (String)path + resourcePath;
        }
        if (!((String)path).endsWith("/")) {
            path = (String)path + "/";
        }
        if (resourceConfiguration.isLocalDirectory()) {
            path = System.getProperty("user.dir").replace('\\', '/') + (String)path;
        }
        return path;
    }

    private StringBuilder preapreTitle(StringBuilder message, IWebServerConfiguration webServerConfiguration) {
        message.append("  ");
        if (webServerConfiguration.getWebserverName() != null && !webServerConfiguration.getWebserverName().isBlank()) {
            message.append(this.parameterText(webServerConfiguration.getWebserverName())).append(" (powered by ").append(APP).append(")");
        } else {
            message.append(this.parameterText(APP));
        }
        message.append(NL);
        return message;
    }

    private StringBuilder prepareListener(StringBuilder message, IWebServerConfiguration webServerConfiguration, List<Undertow.ListenerInfo> listenerInfoList, String resourcePath) {
        if (listenerInfoList != null && !listenerInfoList.isEmpty()) {
            for (Undertow.ListenerInfo listenerInfo : listenerInfoList) {
                InetAddress address;
                StringBuilder listenerInfoMessage = new StringBuilder();
                if (listenerInfo.getSslContext() == null) {
                    listenerInfoMessage.append(listenerInfo.getProtcol());
                } else {
                    listenerInfoMessage.append(listenerInfo.getSslContext().getProtocol());
                }
                listenerInfoMessage.append(":/");
                String listenerAddress = String.valueOf(listenerInfo.getAddress());
                if (listenerInfo.getAddress() instanceof InetSocketAddress && (address = ((InetSocketAddress)listenerInfo.getAddress()).getAddress()) instanceof Inet6Address && listenerInfoList.size() == 1) {
                    if (webServerConfiguration.getPort() != null) {
                        listenerAddress = "/" + webServerConfiguration.getHostname() + ":" + webServerConfiguration.getPort();
                    }
                    if (webServerConfiguration.getSecurePort() != null) {
                        listenerAddress = "/" + webServerConfiguration.getHostname() + ":" + webServerConfiguration.getSecurePort();
                    }
                }
                listenerInfoMessage.append(listenerAddress);
                if (!"/".equals(resourcePath)) {
                    listenerInfoMessage.append(resourcePath);
                }
                listenerInfoMessage.append(NL);
                this.prepareHeader(message, "Listener");
                message.append(this.commandText(listenerInfoMessage.toString()));
            }
        }
        return message;
    }

    private StringBuilder prepareProxy(StringBuilder message, IWebServerConfiguration webServerConfiguration, String resourcePath) {
        return this.prepareHeader(message, "Proxy").append(this.commandText(resourcePath)).append(" -> ").append(this.commandText(ConfigurationUtil.getInstance().formatArrayAsString(webServerConfiguration.getProxyServerConfiguration().getProxyHostNames()))).append(NL);
    }

    private StringBuilder prepareResource(StringBuilder message, IWebServerConfiguration webServerConfiguration, String resourcePath) {
        String path = this.preparePath(webServerConfiguration.getResourceServerConfiguration(), resourcePath);
        String pathType = "{PATH}:";
        if (webServerConfiguration.getResourceServerConfiguration().readFromClasspath()) {
            pathType = " {CLASSPATH}:";
        }
        return this.prepareHeader(message, "Resource").append(this.commandText(resourcePath)).append(" -> ").append(pathType).append(this.commandText(path)).append(NL);
    }

    private String commandText(String message) {
        if (this.getColorScheme() != null) {
            return String.valueOf(this.getColorScheme().commandText(message));
        }
        return message;
    }

    private String parameterText(String message) {
        if (this.getColorScheme() != null) {
            return String.valueOf(this.getColorScheme().parameterText(message));
        }
        return message;
    }

    private StringBuilder prepareHeader(StringBuilder message, String tag) {
        message.append("  > ");
        message.append(tag);
        for (int i = tag.length(); i < 11; ++i) {
            message.append(' ');
        }
        return message;
    }
}

