/*
 * Decompiled with CFR 0.152.
 */
package com.github.toolarium.jwebserver.logger.access;

import com.github.toolarium.jwebserver.config.IWebServerConfiguration;
import com.github.toolarium.jwebserver.logger.VerboseLevel;
import com.github.toolarium.jwebserver.logger.access.Slf4jAccessLogReceiver;
import com.github.toolarium.jwebserver.logger.access.StdoutAccessLogReceiver;
import com.github.toolarium.jwebserver.logger.logback.LogbackUtil;
import io.undertow.server.HttpHandler;
import io.undertow.server.handlers.accesslog.AccessLogHandler;
import io.undertow.server.handlers.accesslog.AccessLogReceiver;
import org.slf4j.Logger;

public final class AccessLogHttpHandler {
    private static final String ACCESSLOG_APPENDER_NAME = AccessLogHttpHandler.class.getCanonicalName();

    private AccessLogHttpHandler() {
    }

    public static HttpHandler addHandler(IWebServerConfiguration webServerConfiguration, HttpHandler handlerToWrap) {
        if (VerboseLevel.VERBOSE.equals((Object)webServerConfiguration.getVerboseLevel()) || VerboseLevel.ACCESS.equals((Object)webServerConfiguration.getVerboseLevel())) {
            Logger log = LogbackUtil.getInstance().createAccessLogAppender(ACCESSLOG_APPENDER_NAME, webServerConfiguration.getAccessLogFilePattern());
            Slf4jAccessLogReceiver accessLogReceiver = new Slf4jAccessLogReceiver(log);
            return new AccessLogHandler(handlerToWrap, (AccessLogReceiver)accessLogReceiver, webServerConfiguration.getAccessLogFormatString(), AccessLogHttpHandler.class.getClassLoader());
        }
        if (VerboseLevel.ACCESS_CONSOLE.equals((Object)webServerConfiguration.getVerboseLevel())) {
            StdoutAccessLogReceiver accessLogReceiver = new StdoutAccessLogReceiver();
            return new AccessLogHandler(handlerToWrap, (AccessLogReceiver)accessLogReceiver, webServerConfiguration.getAccessLogFormatString(), AccessLogHttpHandler.class.getClassLoader());
        }
        return handlerToWrap;
    }
}

