/*
 * Decompiled with CFR 0.152.
 */
package com.github.toolarium.jwebserver.logger.logback;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.encoder.PatternLayoutEncoder;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.rolling.RollingFileAppender;
import ch.qos.logback.core.rolling.SizeAndTimeBasedRollingPolicy;
import ch.qos.logback.core.rolling.TimeBasedRollingPolicy;
import ch.qos.logback.core.util.FileSize;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LogbackUtil {
    private static final Logger LOG = LoggerFactory.getLogger(LogbackUtil.class);
    private boolean enableVerbose = false;

    private LogbackUtil() {
    }

    public static LogbackUtil getInstance() {
        return HOLDER.INSTANCE;
    }

    public void enableVerbose() {
        if (!this.enableVerbose) {
            String filePattern = "logs/jwebserver-%d{yyyy-MM-dd}.log.gz";
            ch.qos.logback.classic.Logger log = (ch.qos.logback.classic.Logger)LogbackUtil.getInstance().createLogAppender("com.github.toolarium.jwebserver", "%-30(%d{ISO8601} - %1.-1level - %-6.6t{5}) - %-100.100(%logger#%M:%L){99} | %msg%n", filePattern, null, true, (FileSize)null, (FileSize)null);
            log.setAdditive(true);
            log.setLevel(Level.DEBUG);
            this.enableVerbose = true;
        }
    }

    public void detachAppender(String appenderName) {
        Logger log = LoggerFactory.getLogger(appenderName);
        if (log instanceof ch.qos.logback.classic.Logger) {
            Appender<ILoggingEvent> appender = ((ch.qos.logback.classic.Logger)log).getAppender(appenderName);
            if (appender != null) {
                if (((ch.qos.logback.classic.Logger)log).detachAppender(appenderName)) {
                    LOG.info("Successful detached appender [" + appenderName + "].");
                }
                if (appender instanceof RollingFileAppender) {
                    ((RollingFileAppender)appender).getEncoder().stop();
                    ((RollingFileAppender)appender).getRollingPolicy().stop();
                }
                appender.stop();
            }
        } else {
            log.info("Could not detach appender [" + appenderName + "].");
        }
    }

    public Logger createAccessLogAppender(String appenderName, String filePattern) {
        return this.createAccessLogAppender(appenderName, filePattern, null, null, null);
    }

    public Logger createAccessLogAppender(String appenderName, String filePattern, Integer maxHistory, String inputMaxFileSize, String inputTotalSize) {
        FileSize maxFileSize = null;
        if (inputMaxFileSize != null) {
            maxFileSize = FileSize.valueOf(inputMaxFileSize);
        }
        FileSize totalSize = null;
        if (inputTotalSize != null) {
            totalSize = FileSize.valueOf(inputTotalSize);
        }
        return this.createLogAppender(appenderName, "%msg%n", filePattern, maxHistory, true, maxFileSize, totalSize);
    }

    public Logger createLogAppender(String appenderName, String linePattern, String filePattern, Integer maxHistory, boolean appendFile, String inputMaxFileSize, String inputTotalSize) {
        FileSize maxFileSize = null;
        if (inputMaxFileSize != null) {
            maxFileSize = FileSize.valueOf(inputMaxFileSize);
        }
        FileSize totalSize = null;
        if (inputTotalSize != null) {
            totalSize = FileSize.valueOf(inputTotalSize);
        }
        return this.createLogAppender(appenderName, linePattern, filePattern, maxHistory, appendFile, maxFileSize, totalSize);
    }

    public Logger createLogAppender(String appenderName, String linePattern, String filePattern, Integer maxHistory, boolean appendFile, FileSize maxFileSize, FileSize totalSize) {
        TimeBasedRollingPolicy logFilePolicy;
        LoggerContext logCtx = (LoggerContext)LoggerFactory.getILoggerFactory();
        PatternLayoutEncoder logEncoder = new PatternLayoutEncoder();
        logEncoder.setContext(logCtx);
        logEncoder.setPattern(linePattern);
        logEncoder.start();
        logEncoder = new PatternLayoutEncoder();
        logEncoder.setContext(logCtx);
        logEncoder.setPattern(linePattern);
        logEncoder.setCharset(StandardCharsets.UTF_8);
        logEncoder.start();
        RollingFileAppender<ILoggingEvent> logFileAppender = new RollingFileAppender<ILoggingEvent>();
        logFileAppender.setContext(logCtx);
        logFileAppender.setName(appenderName);
        logFileAppender.setEncoder(logEncoder);
        logFileAppender.setAppend(appendFile);
        if (maxFileSize != null) {
            SizeAndTimeBasedRollingPolicy sizeAndTimeBasedRollingPolicy = new SizeAndTimeBasedRollingPolicy();
            sizeAndTimeBasedRollingPolicy.setContext(logCtx);
            sizeAndTimeBasedRollingPolicy.setParent(logFileAppender);
            sizeAndTimeBasedRollingPolicy.setFileNamePattern(filePattern);
            if (maxHistory != null) {
                sizeAndTimeBasedRollingPolicy.setMaxHistory(maxHistory);
            }
            if (maxFileSize != null) {
                sizeAndTimeBasedRollingPolicy.setMaxFileSize(maxFileSize);
            }
            if (totalSize != null) {
                sizeAndTimeBasedRollingPolicy.setTotalSizeCap(totalSize);
            }
            sizeAndTimeBasedRollingPolicy.start();
            logFilePolicy = sizeAndTimeBasedRollingPolicy;
        } else {
            TimeBasedRollingPolicy timeBasedRollingPolicy = new TimeBasedRollingPolicy();
            timeBasedRollingPolicy.setContext(logCtx);
            timeBasedRollingPolicy.setParent(logFileAppender);
            timeBasedRollingPolicy.setFileNamePattern(filePattern);
            if (maxHistory != null) {
                timeBasedRollingPolicy.setMaxHistory(maxHistory);
            }
            if (totalSize != null) {
                timeBasedRollingPolicy.setTotalSizeCap(totalSize);
            }
            timeBasedRollingPolicy.start();
            logFilePolicy = timeBasedRollingPolicy;
        }
        logFileAppender.setRollingPolicy(logFilePolicy);
        logFileAppender.start();
        ch.qos.logback.classic.Logger log = logCtx.getLogger(appenderName);
        log.setAdditive(false);
        log.setLevel(Level.INFO);
        log.addAppender((Appender<ILoggingEvent>)logFileAppender);
        LOG.info("Successful added appender [" + appenderName + "].");
        return log;
    }

    public ch.qos.logback.classic.Logger getLogger(String name) {
        LoggerContext logCtx = (LoggerContext)LoggerFactory.getILoggerFactory();
        return logCtx.getLogger(name);
    }

    private static final class HOLDER {
        static final LogbackUtil INSTANCE = new LogbackUtil();

        private HOLDER() {
        }
    }
}

