/*
 * Decompiled with CFR 0.152.
 */
package com.github.toolarium.jwebserver.util;

import com.github.toolarium.common.security.ISecuredValue;
import com.github.toolarium.common.security.SecuredValue;
import com.github.toolarium.common.util.ClassInstanceUtil;
import com.github.toolarium.security.certificate.CertificateUtilFactory;
import com.github.toolarium.security.certificate.dto.CertificateStore;
import com.github.toolarium.security.keystore.ISecurityManagerProvider;
import com.github.toolarium.security.keystore.impl.SecurityManagerProviderImpl;
import com.github.toolarium.security.keystore.util.KeyStoreUtil;
import java.io.File;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLContext;

public final class CertificateUtil {
    private CertificateUtil() {
    }

    public static CertificateUtil getInstance() {
        return HOLDER.INSTANCE;
    }

    public ISecurityManagerProvider getSecurityManagerProvider(String trustKeyStoreFilename, String keyStoreFilename, String keyStoreType, String keyStoreAlias, ISecuredValue<String> keyStorePassword) throws GeneralSecurityException, IOException {
        File keyStoreFile;
        File trustKeyStoreFile;
        SecurityManagerProviderImpl securityManagerProvider = null;
        KeyStore trustManagerKeyStore = null;
        if (trustKeyStoreFilename != null && !trustKeyStoreFilename.isBlank() && (trustKeyStoreFile = new File(trustKeyStoreFilename)).exists()) {
            trustManagerKeyStore = KeyStoreUtil.getInstance().readKeyStore(trustKeyStoreFile.getName(), keyStoreType, null, null);
        }
        if (trustManagerKeyStore == null) {
            trustManagerKeyStore = KeyStoreUtil.getInstance().getDefaultTrustKeyStore();
        }
        if (keyStoreFilename != null && !keyStoreFilename.isBlank() && (keyStoreFile = new File(keyStoreFilename)).exists()) {
            KeyStore keyManagerKeyStore = KeyStoreUtil.getInstance().readKeyStore(keyStoreFile.getPath(), keyStoreType, null, keyStorePassword);
            securityManagerProvider = new SecurityManagerProviderImpl(trustManagerKeyStore, keyManagerKeyStore, keyStorePassword);
        }
        if (securityManagerProvider == null) {
            if (!ClassInstanceUtil.getInstance().isClassAvailable("org.bouncycastle.jce.provider.BouncyCastleProvider")) {
                throw new GeneralSecurityException();
            }
            ISecuredValue<String> pw = keyStorePassword;
            if (pw == null) {
                pw = new SecuredValue<String>("changeit");
            }
            String certificateStoreAlias = "toolarium";
            if (keyStoreAlias != null) {
                certificateStoreAlias = keyStoreAlias;
            }
            CertificateStore certificateStore = CertificateUtilFactory.getInstance().getGenerator().createCreateCertificate(certificateStoreAlias);
            KeyStore keyManagerStore = certificateStore.toKeyStore(certificateStoreAlias, keyStorePassword.getValue());
            X509Certificate selfSignedCertificate = (X509Certificate)keyManagerStore.getCertificate(certificateStoreAlias);
            KeyStoreUtil.getInstance().addCertificateToKeystore(trustManagerKeyStore, certificateStoreAlias, new X509Certificate[]{selfSignedCertificate});
            securityManagerProvider = new SecurityManagerProviderImpl(trustManagerKeyStore, keyManagerStore, pw);
        }
        return securityManagerProvider;
    }

    public SSLContext createSSLContext(ISecurityManagerProvider securityManagerProvider, boolean trustAnyCertificate) throws GeneralSecurityException {
        SSLContext sslContext = SSLContext.getInstance("TLS");
        if (trustAnyCertificate) {
            sslContext.init(securityManagerProvider.getKeyManagers(), KeyStoreUtil.getInstance().getTrustAllCertificateManager(), SecureRandom.getInstanceStrong());
        } else {
            sslContext.init(securityManagerProvider.getKeyManagers(), securityManagerProvider.getTrustManagers(), SecureRandom.getInstanceStrong());
        }
        return sslContext;
    }

    private static final class HOLDER {
        static final CertificateUtil INSTANCE = new CertificateUtil();

        private HOLDER() {
        }
    }
}

