/*
 * Decompiled with CFR 0.152.
 */
package com.github.toolarium.jwebserver.util;

import com.github.toolarium.common.security.ISecuredValue;
import com.github.toolarium.common.security.SecuredValue;
import com.github.toolarium.common.util.PropertyExpander;
import com.github.toolarium.jwebserver.logger.VerboseLevel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ConfigurationUtil {
    private static final Logger LOG = LoggerFactory.getLogger(ConfigurationUtil.class);
    private static final String END_VALUE = "].";

    private ConfigurationUtil() {
    }

    public static ConfigurationUtil getInstance() {
        return HOLDER.INSTANCE;
    }

    public String expand(String value) {
        if (value == null) {
            return value;
        }
        String result = PropertyExpander.getInstance().expand(value);
        if (!value.equals(result)) {
            LOG.debug("Resolved value [" + value + "] to [" + result + "].  ");
        }
        return result;
    }

    public String[] expand(String[] valueList) {
        if (valueList == null || valueList.length == 0) {
            return valueList;
        }
        String[] expandedList = new String[valueList.length];
        for (int i = 0; i < expandedList.length; ++i) {
            expandedList[i] = this.expand(valueList[i]);
        }
        return expandedList;
    }

    public Integer convert(String name, String value, Integer defaultValue) {
        try {
            return Integer.valueOf(this.expand(this.expand(value)));
        }
        catch (Exception e) {
            Object nameMsg = "";
            if (name != null) {
                nameMsg = "for attribute [" + name + "]";
            }
            LOG.warn("Invalid value [" + value + "] " + (String)nameMsg + ", keep default value [" + defaultValue + END_VALUE);
            return defaultValue;
        }
    }

    public Boolean convert(String name, String value, Boolean defaultValue) {
        try {
            return Boolean.valueOf(this.expand(value));
        }
        catch (Exception e) {
            Object nameMsg = "";
            if (name != null) {
                nameMsg = "for attribute [" + name + "]";
            }
            LOG.warn("Invalid value [" + value + "] " + (String)nameMsg + ", keep default value [" + defaultValue + END_VALUE);
            return defaultValue;
        }
    }

    public VerboseLevel convert(String name, String value, VerboseLevel defaultValue) {
        try {
            return VerboseLevel.valueOf(this.expand(value));
        }
        catch (Exception e) {
            Object nameMsg = "";
            if (name != null) {
                nameMsg = "for attribute [" + name + "]";
            }
            LOG.warn("Invalid value [" + value + "] " + (String)nameMsg + ", keep default value [" + String.valueOf((Object)defaultValue) + END_VALUE);
            return defaultValue;
        }
    }

    public ISecuredValue<String> convert(String name, String value, ISecuredValue<String> defaultValue) {
        try {
            return new SecuredValue<String>(this.expand(value));
        }
        catch (Exception e) {
            Object nameMsg = "";
            if (name != null) {
                nameMsg = "for attribute [" + name + "]";
            }
            LOG.warn("Invalid value [" + value + "] " + (String)nameMsg + ", keep default value [" + String.valueOf(defaultValue) + END_VALUE);
            return defaultValue;
        }
    }

    public String[] parseStringArray(String stringArray) {
        if (stringArray == null || stringArray.isBlank()) {
            return null;
        }
        String[] stringArrayList = stringArray.split(",");
        for (int i = 0; i < stringArrayList.length; ++i) {
            stringArrayList[i] = stringArrayList[i].trim();
        }
        return stringArrayList;
    }

    public String formatArrayAsString(String[] stringArray) {
        if (stringArray == null) {
            return null;
        }
        StringBuilder formatString = new StringBuilder();
        for (String welcomeFile : stringArray) {
            if (!formatString.toString().isEmpty()) {
                formatString.append(", ");
            }
            formatString.append(welcomeFile);
        }
        return formatString.toString();
    }

    private static final class HOLDER {
        static final ConfigurationUtil INSTANCE = new ConfigurationUtil();

        private HOLDER() {
        }
    }
}

