/*
 * Decompiled with CFR 0.152.
 */
package com.github.toolarium.jwebserver.util;

import io.undertow.server.handlers.resource.Resource;
import io.undertow.util.CanonicalPathUtils;

public final class ResourceUtil {
    private ResourceUtil() {
    }

    public static ResourceUtil getInstance() {
        return HOLDER.INSTANCE;
    }

    public String slashify(String base) {
        if (base == null) {
            return base;
        }
        if (base.endsWith("/")) {
            return base;
        }
        return base + "/";
    }

    public String canonicalize(String s) {
        return CanonicalPathUtils.canonicalize(s);
    }

    public String prepareString(String[] input, int size) {
        if (input == null || input.length == 0 || size == 0) {
            return "/";
        }
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < input.length && i <= size; ++i) {
            builder.append(input[i]);
            builder.append("/");
        }
        return builder.toString();
    }

    public String toString(Resource resource) {
        StringBuilder builder = new StringBuilder();
        if (resource != null) {
            builder.append(" -> ");
            builder.append(resource.getName());
            builder.append(" | ");
            if (resource.isDirectory()) {
                builder.append("*");
            } else {
                builder.append(resource.getContentLength());
            }
            builder.append(" | ");
            builder.append(resource.getResourceManagerRootPath());
            builder.append(" | ");
            builder.append(resource.getLastModifiedString());
        }
        return builder.toString();
    }

    private static final class HOLDER {
        static final ResourceUtil INSTANCE = new ResourceUtil();

        private HOLDER() {
        }
    }
}

