/*
 * Decompiled with CFR 0.152.
 */
package com.github.toolarium.security.certificate;

import com.github.toolarium.security.certificate.ICertificateChainAnalyzer;
import com.github.toolarium.security.certificate.ICertificateConverter;
import com.github.toolarium.security.certificate.ICertificateFilter;
import com.github.toolarium.security.certificate.ICertificateGenerator;
import com.github.toolarium.security.certificate.ICertificateVerifier;
import com.github.toolarium.security.certificate.impl.CertificateChainAnalyzer;
import com.github.toolarium.security.certificate.impl.CertificateConverter;
import com.github.toolarium.security.certificate.impl.CertificateFilter;
import com.github.toolarium.security.certificate.impl.CertificateGenerator;
import com.github.toolarium.security.certificate.impl.CertificateVerifier;

public final class CertificateUtilFactory {
    private ICertificateGenerator certificateGenerator;
    private ICertificateConverter certificateConverter;
    private ICertificateFilter certificateFilter;
    private ICertificateVerifier certificateVerifier;
    private ICertificateChainAnalyzer certificateChainAnalyzer;

    private CertificateUtilFactory() {
    }

    public static CertificateUtilFactory getInstance() {
        return HOLDER.INSTANCE;
    }

    public ICertificateGenerator getGenerator() {
        if (this.certificateGenerator == null) {
            this.certificateGenerator = new CertificateGenerator();
        }
        return this.certificateGenerator;
    }

    public ICertificateConverter getConverter() {
        if (this.certificateConverter == null) {
            this.certificateConverter = new CertificateConverter();
        }
        return this.certificateConverter;
    }

    public ICertificateFilter getFilter() {
        if (this.certificateFilter == null) {
            this.certificateFilter = new CertificateFilter();
        }
        return this.certificateFilter;
    }

    public ICertificateVerifier getVerifier() {
        if (this.certificateVerifier == null) {
            this.certificateVerifier = new CertificateVerifier();
        }
        return this.certificateVerifier;
    }

    public ICertificateChainAnalyzer geChainAnalyzer() {
        if (this.certificateChainAnalyzer == null) {
            this.certificateChainAnalyzer = new CertificateChainAnalyzer();
        }
        return this.certificateChainAnalyzer;
    }

    private static class HOLDER {
        static final CertificateUtilFactory INSTANCE = new CertificateUtilFactory();

        private HOLDER() {
        }
    }
}

