/*
 * Decompiled with CFR 0.152.
 */
package com.github.toolarium.security.certificate;

import java.security.KeyPair;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.List;
import javax.security.auth.x500.X500Principal;

public interface ICertificateChainAnalyzer {
    public List<X509Certificate> buildChainFor(KeyPair var1, Collection<X509Certificate> var2);

    public List<X509Certificate> buildChainFor(PublicKey var1, Collection<X509Certificate> var2) throws IllegalArgumentException, IllegalStateException;

    public X509Certificate getCertificateFor(PublicKey var1, Collection<X509Certificate> var2);

    public boolean isSelfSigned(X509Certificate var1);

    public boolean isSignedBy(X509Certificate var1, PublicKey var2);

    public X509Certificate getIssuer(X509Certificate var1, Collection<X509Certificate> var2);

    public X500Principal[] getPrincipals(List<X509Certificate> var1);

    public List<X509Certificate> normaliseChain(List<X509Certificate> var1);

    public List<X509Certificate> toRootFirst(List<X509Certificate> var1);
}

