/*
 * Decompiled with CFR 0.152.
 */
package com.github.toolarium.security.certificate.dto;

import com.github.toolarium.common.security.ISecuredValue;
import com.github.toolarium.common.security.SecuredValue;
import com.github.toolarium.security.certificate.CertificateUtilFactory;
import com.github.toolarium.security.keystore.util.KeyStoreUtil;
import com.github.toolarium.security.pki.KeyConverterFactory;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Serializable;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.X509Certificate;

public class CertificateStore
implements Serializable {
    private static final long serialVersionUID = 1176088618605044855L;
    private final X509Certificate[] certificates;
    private final KeyPair keypair;

    public CertificateStore(String fileName, String alias, String password) throws GeneralSecurityException, IOException {
        this(fileName, alias, new SecuredValue<String>(password, "..."));
    }

    public CertificateStore(String fileName, String alias, ISecuredValue<String> password) throws GeneralSecurityException, IOException {
        CertificateStore s = KeyStoreUtil.getInstance().readPKCS12KeyPair(fileName, null, alias, password);
        this.certificates = s.getCertificates();
        this.keypair = s.getKeyPair();
    }

    public CertificateStore(KeyPair keypair, X509Certificate ... certificates) {
        this.certificates = certificates;
        this.keypair = keypair;
    }

    public X509Certificate[] getCertificates() {
        return this.certificates;
    }

    public KeyPair getKeyPair() {
        return this.keypair;
    }

    public KeyStore toKeyStore(String alias, String password) throws GeneralSecurityException, IOException {
        return KeyStoreUtil.getInstance().createPKCS12KeyStore(null, alias, this.keypair.getPrivate(), this.certificates, new SecuredValue<String>(password, "..."));
    }

    public KeyStore write(String fileName, String alias, String password) throws GeneralSecurityException, IOException {
        return KeyStoreUtil.getInstance().writePKCS12KeyStore(this.prepareFilename(fileName, ".p12"), alias, this.keypair.getPrivate(), this.certificates, new SecuredValue<String>(password, "..."));
    }

    public KeyStore write(String fileName, String alias, ISecuredValue<String> password) throws GeneralSecurityException, IOException {
        return KeyStoreUtil.getInstance().writePKCS12KeyStore(this.prepareFilename(fileName, ".p12"), alias, this.keypair.getPrivate(), this.certificates, password);
    }

    public X509Certificate[] writeCertificate(String fileName) throws GeneralSecurityException, IOException {
        this.write(this.prepareFilename(fileName, ".crt"), CertificateUtilFactory.getInstance().getConverter().formatPKCS7(this.certificates));
        return this.certificates;
    }

    public PublicKey writePublicKey(String fileName) throws GeneralSecurityException, IOException {
        PublicKey publicKey = this.keypair.getPublic();
        this.write(this.prepareFilename(fileName, ".pub"), KeyConverterFactory.getInstance().getConverter(publicKey).formatPublicKey(publicKey));
        return publicKey;
    }

    public PrivateKey writePrivateKey(String fileName) throws GeneralSecurityException, IOException {
        PrivateKey privateKey = this.keypair.getPrivate();
        this.write(this.prepareFilename(fileName, ".pem"), KeyConverterFactory.getInstance().getConverter(privateKey).formatPrivateKey(privateKey));
        return privateKey;
    }

    private void write(String inputFileName, String content) throws IOException {
        String fileName = inputFileName;
        FileWriter writer = new FileWriter(new File(fileName));
        writer.append(content);
        writer.flush();
        writer.close();
        new File(fileName).setReadable(false, true);
    }

    private String prepareFilename(String inputfileName, String ending) {
        String fileName = inputfileName;
        if (!fileName.endsWith(ending)) {
            if (!fileName.endsWith(".") && !ending.startsWith(".")) {
                fileName = fileName + ".";
            }
            fileName = fileName + ending;
        }
        return fileName;
    }
}

