/*
 * Decompiled with CFR 0.152.
 */
package com.github.toolarium.security.certificate.impl;

import com.github.toolarium.security.certificate.ICertificateChainAnalyzer;
import java.security.KeyPair;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.security.auth.x500.X500Principal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CertificateChainAnalyzer
implements ICertificateChainAnalyzer {
    private static final Logger LOG = LoggerFactory.getLogger(CertificateChainAnalyzer.class);
    private static final boolean ALLOW_LOG_SELF_SIGN_TESTS = false;

    @Override
    public List<X509Certificate> buildChainFor(KeyPair keypair, Collection<X509Certificate> certs) {
        return this.buildChainFor(keypair.getPublic(), certs);
    }

    @Override
    public List<X509Certificate> buildChainFor(PublicKey key, Collection<X509Certificate> certs) throws IllegalArgumentException, IllegalStateException {
        ArrayList<X509Certificate> chain = new ArrayList<X509Certificate>(certs.size());
        X509Certificate subject = this.getCertificateFor(key, certs);
        if (subject == null) {
            throw new IllegalArgumentException("Cannot find X509Certificate which corresponds to " + key);
        }
        chain.add(subject);
        Certificate old = null;
        X509Certificate current = subject;
        while (!(current == null || old != null && old.equals(current) || this.isSelfSigned(current))) {
            old = current;
            if ((current = this.getIssuer(current, certs)) == null) {
                LOG.warn("Building chain for " + certs.size() + " cert[s] but had to stop after " + chain.size() + " because I could not find the issuer for " + ((X509Certificate)old).getSubjectX500Principal());
                throw new IllegalArgumentException("Could not determine issuer for certificate: " + ((X509Certificate)old).getSubjectX500Principal() + ". Please ensure certificate list contains all certificates back to the CA's self-signed root!");
            }
            chain.add(current);
            if (chain.size() <= certs.size()) continue;
            LOG.warn("Too many certificates in chain. Chain: " + Arrays.toString(this.getPrincipals(chain)) + ", Source: " + Arrays.toString(this.getPrincipals(new ArrayList<X509Certificate>(certs))));
            throw new IllegalStateException("Chain build failed: too many certs in chain (greater than number of input certs)! Chain: " + Arrays.toString(this.getPrincipals(chain)));
        }
        return this.normaliseChain(chain);
    }

    @Override
    public X509Certificate getCertificateFor(PublicKey publicKey, Collection<X509Certificate> certs) {
        for (X509Certificate cert : certs) {
            if (!cert.getPublicKey().equals(publicKey)) continue;
            return cert;
        }
        return null;
    }

    @Override
    public boolean isSelfSigned(X509Certificate certificate) {
        return this.isSignedBy(certificate, certificate.getPublicKey());
    }

    @Override
    public boolean isSignedBy(X509Certificate certificate, PublicKey signer) {
        try {
            certificate.verify(signer);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public X509Certificate getIssuer(X509Certificate subject, Collection<X509Certificate> certs) {
        for (X509Certificate cert : certs) {
            if (!cert.getSubjectX500Principal().equals(subject.getIssuerX500Principal()) || !this.isSignedBy(subject, cert.getPublicKey())) continue;
            return cert;
        }
        return null;
    }

    @Override
    public X500Principal[] getPrincipals(List<X509Certificate> chain) {
        if (chain.contains(null)) {
            throw new IllegalArgumentException("Certificate chain contains null!");
        }
        X500Principal[] array = new X500Principal[chain.size()];
        for (int i = 0; i < array.length; ++i) {
            array[i] = chain.get(i).getSubjectX500Principal();
        }
        return array;
    }

    @Override
    public List<X509Certificate> normaliseChain(List<X509Certificate> chain) {
        return this.toRootFirst(chain);
    }

    @Override
    public List<X509Certificate> toRootFirst(List<X509Certificate> chain) {
        List<X509Certificate> out;
        if (chain == null || chain.isEmpty()) {
            throw new IllegalArgumentException("Must provide a chain that is non-null and non-empty");
        }
        if (!this.isSelfSigned(chain.get(0))) {
            out = new ArrayList<X509Certificate>(chain);
            Collections.reverse(out);
            if (!this.isSelfSigned(out.get(0))) {
                throw new IllegalArgumentException("Neither end of the certificate chain has a Root! " + chain);
            }
        } else {
            out = chain;
        }
        return Collections.unmodifiableList(out);
    }
}

