/*
 * Decompiled with CFR 0.152.
 */
package com.github.toolarium.security.certificate.impl;

import com.github.toolarium.common.util.FileUtil;
import com.github.toolarium.security.certificate.ICertificateConverter;
import com.github.toolarium.security.pki.util.PKIUtil;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Base64;

public class CertificateConverter
implements ICertificateConverter {
    public static final String PUBLIC_CERTIFICATE_START = "-----BEGIN CERTIFICATE-----";
    public static final String PUBLIC_CERTIFICATE_END = "-----END CERTIFICATE-----";
    private static final String NL = "\n";

    @Override
    public X509Certificate[] getX509Certificates(File file) throws GeneralSecurityException, IOException {
        if (file == null) {
            return null;
        }
        return this.getX509Certificates(FileUtil.getInstance().readFileContent(file));
    }

    @Override
    public X509Certificate[] getX509Certificates(String content) throws GeneralSecurityException {
        if (content == null || content.length() == 0) {
            return null;
        }
        String data = content.trim().replaceAll(" ", NL).replaceAll("\nCERTIFICATE", " CERTIFICATE");
        String formatedCertificate = this.formatPKCS7(data);
        ArrayList<X509Certificate> certificates = new ArrayList<X509Certificate>();
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        ByteArrayInputStream bais = new ByteArrayInputStream(formatedCertificate.getBytes());
        X509Certificate cert = null;
        while (bais.available() > 0) {
            cert = (X509Certificate)cf.generateCertificate(bais);
            certificates.add(cert);
        }
        X509Certificate[] certs = new X509Certificate[certificates.size()];
        for (int i = 0; i < certs.length; ++i) {
            certs[i] = (X509Certificate)certificates.get(i);
        }
        return certs;
    }

    @Override
    public X509Certificate[] combineCertificates(X509Certificate[] certs, X509Certificate[] caCerts) {
        int i;
        X509Certificate[] combinedCerts = null;
        int len = 0;
        int offset = 0;
        if (certs != null) {
            len += certs.length;
        }
        if (caCerts != null) {
            len += caCerts.length;
        }
        if (len <= 0) {
            return null;
        }
        combinedCerts = new X509Certificate[len];
        if (certs != null) {
            for (i = 0; i < certs.length; ++i) {
                combinedCerts[offset++] = certs[i];
            }
        }
        if (caCerts != null) {
            for (i = 0; i < caCerts.length; ++i) {
                combinedCerts[offset++] = caCerts[i];
            }
        }
        return combinedCerts;
    }

    @Override
    public String formatPKCS7(String rawCertificate) {
        return PKIUtil.getInstance().formatBuffer(rawCertificate, 64, PUBLIC_CERTIFICATE_START, PUBLIC_CERTIFICATE_END);
    }

    @Override
    public String formatPKCS7(Certificate certificate) throws CertificateEncodingException {
        if (certificate == null) {
            return null;
        }
        return this.formatPKCS7(new String(Base64.getEncoder().encode(certificate.getEncoded())));
    }

    @Override
    public String formatPKCS7(X509Certificate[] certificateChain) throws CertificateEncodingException {
        String certificateChainContent = "";
        for (int i = 0; i < certificateChain.length; ++i) {
            String cert;
            if (i > 0) {
                certificateChainContent = certificateChainContent + NL;
            }
            if ((cert = this.formatPKCS7(certificateChain[i])) == null) continue;
            certificateChainContent = certificateChainContent + cert;
        }
        return certificateChainContent;
    }
}

