/*
 * Decompiled with CFR 0.152.
 */
package com.github.toolarium.security.certificate.impl;

import com.github.toolarium.security.certificate.ICertificateFilter;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;

public class CertificateFilter
implements ICertificateFilter {
    @Override
    public List<X509Certificate> filterValid(List<X509Certificate> certificates) {
        LinkedList<X509Certificate> result = new LinkedList<X509Certificate>();
        Date dateToCheck = new Date();
        for (X509Certificate certificate : certificates) {
            try {
                certificate.checkValidity(dateToCheck);
                result.add(certificate);
            }
            catch (CertificateExpiredException certificateExpiredException) {
            }
            catch (CertificateNotYetValidException certificateNotYetValidException) {}
        }
        Collections.sort(result, Comparator.comparing(X509Certificate::getNotAfter));
        return result;
    }

    @Override
    public List<X509Certificate> filterExpired(List<X509Certificate> certificates) {
        LinkedList<X509Certificate> result = new LinkedList<X509Certificate>();
        Date dateToCheck = new Date();
        for (X509Certificate certificate : certificates) {
            try {
                certificate.checkValidity(dateToCheck);
            }
            catch (CertificateExpiredException e) {
                result.add(certificate);
            }
            catch (CertificateNotYetValidException certificateNotYetValidException) {}
        }
        Collections.sort(result, Comparator.comparing(X509Certificate::getNotAfter));
        return result;
    }

    @Override
    public List<X509Certificate> filterNotYedValid(List<X509Certificate> certificates) {
        LinkedList<X509Certificate> result = new LinkedList<X509Certificate>();
        Date dateToCheck = new Date();
        for (X509Certificate certificate : certificates) {
            try {
                certificate.checkValidity(dateToCheck);
            }
            catch (CertificateExpiredException certificateExpiredException) {
            }
            catch (CertificateNotYetValidException e) {
                result.add(certificate);
            }
        }
        Collections.sort(result, Comparator.comparing(X509Certificate::getNotBefore));
        return result;
    }
}

