/*
 * Decompiled with CFR 0.152.
 */
package com.github.toolarium.security.certificate.impl;

import com.github.toolarium.security.certificate.CertificateUtilFactory;
import com.github.toolarium.security.certificate.ICertificateGenerator;
import com.github.toolarium.security.certificate.dto.CertificateStore;
import com.github.toolarium.security.pki.util.PKIUtil;
import java.io.IOException;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.util.Date;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.X500NameBuilder;
import org.bouncycastle.asn1.x500.style.BCStyle;
import org.bouncycastle.asn1.x509.AuthorityKeyIdentifier;
import org.bouncycastle.asn1.x509.BasicConstraints;
import org.bouncycastle.asn1.x509.ExtendedKeyUsage;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.asn1.x509.KeyPurposeId;
import org.bouncycastle.asn1.x509.KeyUsage;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.X509v3CertificateBuilder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cert.jcajce.JcaX509ExtensionUtils;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CertificateGenerator
implements ICertificateGenerator {
    private static final long ONE_DAY = 86400000L;
    private static final Logger LOG = LoggerFactory.getLogger(CertificateGenerator.class);

    @Override
    public CertificateStore createCreateCertificate(CertificateStore certificateStore, String dn, String alternativeDn, Date startDate, int validityDays) throws GeneralSecurityException {
        return this.createCreateCertificate(certificateStore.getKeyPair(), certificateStore, dn, alternativeDn, startDate, validityDays);
    }

    @Override
    public CertificateStore createCreateCertificate(String dn) throws GeneralSecurityException {
        return this.createCreateCertificate(PKIUtil.getInstance().generateKeyPair(null, "RSA", 2048), null, dn, null, new Date(), 365);
    }

    @Override
    public CertificateStore createCreateCertificate(String dn, String alternativeDn, int validityDays) throws GeneralSecurityException {
        return this.createCreateCertificate(PKIUtil.getInstance().generateKeyPair(null, "RSA", 2048), null, dn, alternativeDn, new Date(), validityDays);
    }

    @Override
    public CertificateStore createCreateCertificate(KeyPair keyPair, String dn, String alternativeDn, Date startDate, int validityDays) throws GeneralSecurityException {
        return this.createCreateCertificate(keyPair, null, dn, alternativeDn, startDate, validityDays);
    }

    @Override
    public CertificateStore createCreateCertificate(KeyPair keyPair, CertificateStore parent, String dn, String alternativeDn, Date startDate, int inputValidityDays) throws GeneralSecurityException {
        try {
            PrivateKey privateKeySigner;
            X500Name issuer;
            LocalDateTime maxDate;
            int validityDays = inputValidityDays;
            if (validityDays < 1) {
                validityDays = 1;
            }
            if (validityDays % 365 == 0) {
                int years = validityDays / 365;
                maxDate = this.dateToLocalDateTime(startDate);
                maxDate = maxDate.plusYears(years);
            } else {
                maxDate = this.dateToLocalDateTime(new Date(startDate.getTime() + 86400000L * (long)(validityDays - 1)));
            }
            BigInteger serial = BigInteger.valueOf(System.currentTimeMillis());
            X500Name name = new X500NameBuilder(BCStyle.INSTANCE).addRDN(BCStyle.CN, dn).build();
            if (parent == null || parent.getCertificates() == null || parent.getCertificates().length <= 0) {
                issuer = name;
                privateKeySigner = keyPair.getPrivate();
            } else {
                privateKeySigner = parent.getKeyPair().getPrivate();
                issuer = new X500Name(parent.getCertificates()[0].getIssuerX500Principal().getName());
            }
            String dnName = alternativeDn;
            if (dnName == null) {
                dnName = dn;
            }
            SubjectPublicKeyInfo publicKeyInfo = SubjectPublicKeyInfo.getInstance(ASN1Sequence.getInstance(keyPair.getPublic().getEncoded()));
            Date notBeforedate = this.localDateTimeToDate(this.dateToLocalDateTime(startDate).with(LocalTime.MIN));
            Date notAfter = this.localDateTimeToDate(maxDate.with(LocalTime.MAX));
            X509v3CertificateBuilder builder = new X509v3CertificateBuilder(issuer, serial, notBeforedate, notAfter, name, publicKeyInfo).addExtension(Extension.subjectAlternativeName, false, new GeneralNames(new GeneralName(2, dnName)));
            boolean isCa = true;
            boolean critical = true;
            JcaX509ExtensionUtils extUtils = new JcaX509ExtensionUtils();
            AuthorityKeyIdentifier authorityKeyIdentifier = extUtils.createAuthorityKeyIdentifier(keyPair.getPublic());
            builder.addExtension(Extension.subjectAlternativeName, false, new GeneralNames(new GeneralName(2, "localhost")));
            builder.addExtension(Extension.subjectKeyIdentifier, false, extUtils.createSubjectKeyIdentifier(keyPair.getPublic()));
            builder.addExtension(Extension.authorityKeyIdentifier, false, authorityKeyIdentifier);
            builder.addExtension(Extension.basicConstraints, isCa, new BasicConstraints(isCa));
            KeyUsage usage = new KeyUsage(238);
            builder.addExtension(Extension.keyUsage, false, usage.getEncoded());
            ExtendedKeyUsage usageEx = new ExtendedKeyUsage(new KeyPurposeId[]{KeyPurposeId.id_kp_serverAuth, KeyPurposeId.id_kp_clientAuth, KeyPurposeId.id_kp_emailProtection});
            builder.addExtension(Extension.extendedKeyUsage, !critical, usageEx.getEncoded());
            String signatureAlgorithm = "SHA256WithRSAEncryption";
            if ("RSA".equals(keyPair.getPublic().getAlgorithm())) {
                signatureAlgorithm = "SHA256WithRSA";
            } else if ("EC".equals(keyPair.getPublic().getAlgorithm())) {
                signatureAlgorithm = "SHA256withECRSA";
            }
            ContentSigner signer = new JcaContentSignerBuilder(signatureAlgorithm).setProvider(new BouncyCastleProvider()).build(privateKeySigner);
            X509CertificateHolder holder = builder.build(signer);
            X509Certificate cert = new JcaX509CertificateConverter().setProvider(new BouncyCastleProvider()).getCertificate(holder);
            int size = 1;
            if (parent != null && parent.getCertificates() != null) {
                size += parent.getCertificates().length;
            }
            X509Certificate[] chain = new X509Certificate[size];
            chain[0] = cert;
            if (parent != null && parent.getCertificates() != null && parent.getCertificates().length > 0) {
                for (int i = parent.getCertificates().length - 1; i >= 0; --i) {
                    chain[i + 1] = parent.getCertificates()[i];
                }
            }
            CertificateUtilFactory.getInstance().getVerifier().verifyCertificateChain(LOG::info, chain);
            return new CertificateStore(keyPair, chain);
        }
        catch (IOException | GeneralSecurityException | OperatorCreationException ex) {
            GeneralSecurityException e = new GeneralSecurityException(ex.getMessage());
            e.setStackTrace(ex.getStackTrace());
            throw e;
        }
    }

    public static void main(String[] args) throws Exception {
        String fileName = "testca";
        CertificateGenerator g = new CertificateGenerator();
        CertificateStore certificateStore = g.createCreateCertificate(PKIUtil.getInstance().generateKeyPair(null, "RSA", 2048), "Test CN", "localhost", new Date(), 365);
        certificateStore.write(fileName, "alias", "4321");
        certificateStore.writeCertificate(fileName);
        certificateStore.writePublicKey(fileName);
        certificateStore.writePrivateKey(fileName);
    }

    private LocalDateTime dateToLocalDateTime(Date date) {
        return LocalDateTime.ofInstant(date.toInstant(), ZoneId.systemDefault());
    }

    private Date localDateTimeToDate(LocalDateTime localDateTime) {
        return Date.from(localDateTime.atZone(ZoneId.systemDefault()).toInstant());
    }
}

