/*
 * Decompiled with CFR 0.152.
 */
package com.github.toolarium.security.keystore.impl;

import com.github.toolarium.common.security.ISecuredValue;
import com.github.toolarium.security.keystore.ISecurityManagerProvider;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecurityManagerProviderImpl
implements ISecurityManagerProvider {
    private static final Logger LOG = LoggerFactory.getLogger(SecurityManagerProviderImpl.class);
    private final transient KeyStore trustManagerStore;
    private final transient KeyStore keyManagerStore;
    private final transient ISecuredValue<String> keyManagerStorePassword;

    public SecurityManagerProviderImpl(KeyStore trustManagerStore, KeyStore keyManagerStore, ISecuredValue<String> keyManagerStorePassword) {
        this.trustManagerStore = trustManagerStore;
        this.keyManagerStore = keyManagerStore;
        this.keyManagerStorePassword = keyManagerStorePassword;
    }

    @Override
    public TrustManager[] getTrustManagers() throws GeneralSecurityException {
        return this.createTrustManagers(this.trustManagerStore);
    }

    @Override
    public KeyManager[] getKeyManagers() throws GeneralSecurityException {
        return this.createKeyManager(this.keyManagerStore, this.keyManagerStorePassword);
    }

    protected KeyManager[] createKeyManager(KeyStore keyStore, ISecuredValue<String> storePassword) throws GeneralSecurityException {
        try {
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            if (keyStore != null) {
                LOG.debug("Initialize key manager factory by [" + keyStore + "] of type " + KeyManagerFactory.getDefaultAlgorithm() + "...");
                if (storePassword != null) {
                    keyManagerFactory.init(keyStore, storePassword.getValue().toCharArray());
                } else {
                    keyManagerFactory.init(keyStore, null);
                }
            }
            return keyManagerFactory.getKeyManagers();
        }
        catch (GeneralSecurityException ex) {
            throw new GeneralSecurityException("Unable to initialise KeyManager:" + ex.getMessage(), ex);
        }
    }

    protected TrustManager[] createTrustManagers(KeyStore keyStore) throws GeneralSecurityException {
        try {
            LOG.debug("Initialize trust manager factory by [" + keyStore + "] of type " + KeyManagerFactory.getDefaultAlgorithm() + "...");
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init(keyStore);
            return trustManagerFactory.getTrustManagers();
        }
        catch (GeneralSecurityException ex) {
            throw new GeneralSecurityException("Unable to initialise TrustManager: " + ex.getMessage(), ex);
        }
    }
}

