/*
 * Decompiled with CFR 0.152.
 */
package com.github.toolarium.security.keystore.util;

import com.github.toolarium.common.security.ISecuredValue;
import com.github.toolarium.security.certificate.CertificateUtilFactory;
import com.github.toolarium.security.certificate.dto.CertificateStore;
import com.github.toolarium.security.pki.util.PKIUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class KeyStoreUtil {
    private static final String PKCS12 = "PKCS12";
    private static final Logger LOG = LoggerFactory.getLogger(KeyStoreUtil.class);

    private KeyStoreUtil() {
    }

    public static KeyStoreUtil getInstance() {
        return HOLDER.INSTANCE;
    }

    public KeyStore createKeyStore(String password) throws GeneralSecurityException, IOException {
        return this.createKeyStore(null, password);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public KeyStore createKeyStore(String fileName, String password) throws GeneralSecurityException, IOException {
        KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
        char[] pw = null;
        if (password != null && !password.isBlank()) {
            pw = password.toCharArray();
        }
        keyStore.load(null, pw);
        if (fileName != null && !fileName.isBlank()) {
            FileOutputStream fos = null;
            try {
                fos = new FileOutputStream(fileName);
                keyStore.store(fos, pw);
            }
            finally {
                if (fos != null) {
                    try {
                        fos.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return keyStore;
    }

    public KeyStore readPKCS12KeyStore(String fileName, ISecuredValue<String> password) throws GeneralSecurityException, IOException {
        return this.readKeyStore(fileName, PKCS12, null, password);
    }

    public KeyStore readPKCS12KeyStore(String fileName, String provider, ISecuredValue<String> password) throws GeneralSecurityException, IOException {
        return this.readKeyStore(fileName, PKCS12, provider, password);
    }

    public KeyStore readKeyStore(String fileName, String type, String provider, ISecuredValue<String> password) throws GeneralSecurityException, IOException {
        if (fileName == null) {
            return null;
        }
        KeyStore ks = provider != null ? KeyStore.getInstance(type, provider) : KeyStore.getInstance(type);
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(new File(fileName)));
        if (password != null && password.getValue() != null) {
            ks.load(in, password.getValue().toCharArray());
        } else {
            ks.load(in, null);
        }
        return ks;
    }

    public CertificateStore readPKCS12KeyPair(String fileName, String provider, String alias, ISecuredValue<String> password) throws GeneralSecurityException, IOException {
        if (fileName == null) {
            return null;
        }
        KeyStore ks = this.readPKCS12KeyStore(fileName, provider, password);
        if (ks == null) {
            throw new GeneralSecurityException("Could not read key keystore: " + fileName);
        }
        if (alias == null) {
            throw new GeneralSecurityException("Invalid alias!");
        }
        X509Certificate cert = (X509Certificate)ks.getCertificate(alias);
        if (cert == null) {
            throw new GeneralSecurityException("Could not read the certificate from keystore: " + fileName);
        }
        PrivateKey privKey = password != null && password.getValue() != null ? (PrivateKey)ks.getKey(alias, password.getValue().toCharArray()) : (PrivateKey)ks.getKey(alias, null);
        if (privKey == null) {
            throw new GeneralSecurityException("Could not read the private key from keystore: " + fileName);
        }
        return new CertificateStore(new KeyPair(cert.getPublicKey(), privKey), cert);
    }

    public KeyStore writePKCS12KeyStore(String fileName, String alias, PrivateKey privateKey, Certificate[] certificates, ISecuredValue<String> password) throws GeneralSecurityException, IOException {
        return this.writePKCS12KeyStore(fileName, null, alias, privateKey, certificates, password);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public KeyStore writePKCS12KeyStore(String fileName, String provider, String alias, PrivateKey privateKey, Certificate[] certificates, ISecuredValue<String> password) throws GeneralSecurityException, IOException {
        if (privateKey == null) {
            throw new GeneralSecurityException("Invalid private key!");
        }
        KeyStore ks = null;
        if (new File(fileName).exists()) {
            try {
                LOG.info("Read existing keystore [" + fileName + "].");
                ks = this.readPKCS12KeyStore(fileName, provider, password);
            }
            catch (IOException e) {
                LOG.error("Invalid keystore: " + fileName);
            }
        }
        if (ks == null) {
            LOG.debug("Create new keystore [" + fileName + "].");
            ks = provider == null ? KeyStore.getInstance(PKCS12) : KeyStore.getInstance(PKCS12, provider);
        }
        if (ks == null) {
            throw new GeneralSecurityException("Could not write keystore: " + fileName);
        }
        char[] pw = null;
        if (password != null && password.getValue() != null) {
            pw = password.getValue().toCharArray();
        }
        if (pw != null) {
            ks.load(null, pw);
        } else {
            ks.load(null, null);
        }
        ks.setKeyEntry(alias, privateKey, pw, certificates);
        try (OutputStream out = null;){
            LOG.debug("Write keystore [" + fileName + "].");
            out = new BufferedOutputStream(new FileOutputStream(new File(fileName)));
            ks.store(out, pw);
            out.flush();
        }
        return ks;
    }

    public KeyStore createPKCS12KeyStore(String provider, String alias, PrivateKey privateKey, Certificate[] certificates, ISecuredValue<String> password) throws GeneralSecurityException, IOException {
        if (privateKey == null) {
            throw new GeneralSecurityException("Invalid private key!");
        }
        KeyStore ks = null;
        LOG.debug("Create new keystore...");
        ks = provider == null ? KeyStore.getInstance(PKCS12) : KeyStore.getInstance(PKCS12, provider);
        char[] pw = null;
        if (password != null && password.getValue() != null) {
            pw = password.getValue().toCharArray();
        }
        if (pw != null) {
            ks.load(null, pw);
        } else {
            ks.load(null, null);
        }
        ks.setKeyEntry(alias, privateKey, pw, certificates);
        return ks;
    }

    public X509TrustManager getDefaultX509TrustManager() throws GeneralSecurityException {
        for (TrustManager tm : this.getDefaultTrustManager()) {
            if (!(tm instanceof X509TrustManager)) continue;
            return (X509TrustManager)tm;
        }
        return null;
    }

    public TrustManager[] getDefaultTrustManager() throws GeneralSecurityException {
        TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        tmf.init((KeyStore)null);
        return tmf.getTrustManagers();
    }

    public KeyStore getDefaultTrustKeyStore() throws GeneralSecurityException, IOException {
        KeyStore trustManagerKeyStore = KeyStoreUtil.getInstance().createKeyStore(null);
        X509TrustManager defaultTm = KeyStoreUtil.getInstance().getDefaultX509TrustManager();
        X509Certificate[] trustedIssuers = defaultTm.getAcceptedIssuers();
        if (trustedIssuers != null) {
            int i = 1;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Init new default trust stire with default trusted issuers: " + trustedIssuers.length);
            }
            for (X509Certificate trustedIssuer : trustedIssuers) {
                trustManagerKeyStore.setCertificateEntry("cert" + i++, trustedIssuer);
            }
        }
        return trustManagerKeyStore;
    }

    public KeyStore addCertificateToTrustKeystore(String alias, X509Certificate certificate) throws GeneralSecurityException, IOException {
        return this.addCertificateToTrustKeystore(alias, new X509Certificate[]{certificate});
    }

    public KeyStore addCertificateToTrustKeystore(String alias, X509Certificate[] certificateChain) throws GeneralSecurityException, IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Add self-signed certificate to trust store with alias " + alias + "...");
        }
        return this.addCertificateToKeystore(this.getDefaultTrustKeyStore(), alias, certificateChain);
    }

    public KeyStore addCertificateToKeystore(KeyStore keyStore, String inputAlias, X509Certificate[] certificateChain) throws GeneralSecurityException, IOException {
        if (keyStore != null && certificateChain != null) {
            String alias = inputAlias;
            if (alias == null) {
                alias = "";
            }
            if (keyStore != null && certificateChain != null) {
                ArrayList<X509Certificate> list = new ArrayList<X509Certificate>();
                list.addAll(CertificateUtilFactory.getInstance().getFilter().filterValid(Arrays.asList(certificateChain)));
                list.addAll(CertificateUtilFactory.getInstance().getFilter().filterNotYedValid(Arrays.asList(certificateChain)));
                for (int i = 0; i < list.size(); ++i) {
                    keyStore.setCertificateEntry(alias + i, (Certificate)list.get(i));
                    if (!LOG.isDebugEnabled()) continue;
                    PKIUtil.getInstance().processCertificate(LOG::debug, "Add certificate to key store:", (X509Certificate)list.get(i));
                }
            }
        }
        return keyStore;
    }

    public TrustManager[] getTrustAllCertificateManager() {
        TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[0];
            }

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }
        }};
        return trustAllCerts;
    }

    private static class HOLDER {
        static final KeyStoreUtil INSTANCE = new KeyStoreUtil();

        private HOLDER() {
        }
    }
}

