/*
 * Decompiled with CFR 0.152.
 */
package com.github.toolarium.security.pki;

import java.io.File;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;

public interface IKeyConverter {
    public String getProvider();

    public String getType();

    public KeyPair generateKeyPair() throws GeneralSecurityException;

    public KeyPair generateKeyPair(String var1, int var2) throws GeneralSecurityException;

    public PublicKey getPublicKey(File var1) throws IOException, GeneralSecurityException;

    public PublicKey getPublicKey(byte[] var1) throws IOException, GeneralSecurityException;

    public PublicKey getPublicKey(String var1) throws IOException, GeneralSecurityException;

    public PrivateKey getPrivateKey(File var1) throws IOException, GeneralSecurityException;

    public PrivateKey getPrivateKey(byte[] var1) throws IOException, GeneralSecurityException;

    public PrivateKey getPrivateKey(String var1) throws IOException, GeneralSecurityException;

    public String formatPublicKey(PublicKey var1);

    public String formatPrivateKey(PrivateKey var1);

    public String formatPKCS8(String var1);

    public String normalizePKCS8(String var1);
}

